/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeId;
import org.alfresco.cmis.dictionary.CMISAbstractTypeDefinition;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;

public class CMISObjectTypeDefinition
extends CMISAbstractTypeDefinition {
    private static final long serialVersionUID = -3131505923356013430L;

    public CMISObjectTypeDefinition(CMISMapping cmisMapping, CMISTypeId typeId, ClassDefinition cmisClassDef, boolean isPublic) {
        this.isPublic = isPublic;
        this.objectTypeId = typeId;
        this.objectTypeQueryName = cmisMapping.buildPrefixEncodedString(typeId.getQName());
        if (cmisClassDef != null) {
            this.cmisClassDef = cmisClassDef;
            this.displayName = cmisClassDef.getTitle() != null ? cmisClassDef.getTitle() : typeId.getId();
            this.description = cmisClassDef.getDescription() != null ? cmisClassDef.getDescription() : this.displayName;
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (parentQName != null) {
                this.parentTypeId = cmisMapping.getCmisTypeId(CMISScope.OBJECT, parentQName);
            }
        }
        this.actionEvaluators = cmisMapping.getActionEvaluators(this.objectTypeId.getScope());
        this.creatable = false;
        this.queryable = false;
        this.fullTextIndexed = false;
        this.includedInSuperTypeQuery = cmisClassDef.getIncludedInSuperTypeQuery();
        this.controllablePolicy = false;
        this.controllableACL = false;
    }

    void createSubTypes(CMISMapping cmisMapping, DictionaryService dictionaryService) {
        this.subTypeIds = new ArrayList();
        Collection subTypes = dictionaryService.getSubTypes(this.objectTypeId.getQName(), false);
        for (QName subType : subTypes) {
            CMISTypeId subTypeId = cmisMapping.getCmisTypeId(subType);
            if (subTypeId == null) continue;
            this.subTypeIds.add(subTypeId);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CMISObjectTypeDefinition[");
        builder.append("Public=").append(this.isPublic()).append(", ");
        builder.append("ObjectTypeId=").append(this.getTypeId()).append(", ");
        builder.append("ObjectTypeQueryName=").append(this.getQueryName()).append(", ");
        builder.append("ObjectTypeDisplayName=").append(this.getDisplayName()).append(", ");
        builder.append("ParentTypeId=").append(this.getParentType() == null ? "<none>" : this.getParentType().getTypeId()).append(", ");
        builder.append("Description=").append(this.getDescription()).append(", ");
        builder.append("Creatable=").append(this.isCreatable()).append(", ");
        builder.append("Queryable=").append(this.isQueryable()).append(", ");
        builder.append("Controllable=").append(this.isControllablePolicy()).append(", ");
        builder.append("IncludedInSuperTypeQuery=").append(this.isIncludedInSuperTypeQuery()).append(", ");
        builder.append("SubTypes=").append(this.getSubTypes(false).size()).append(", ");
        builder.append("Properties=").append(this.getPropertyDefinitions().size());
        builder.append("]");
        return builder.toString();
    }
}

