/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.renditions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.alfresco.cmis.CMISRendition;
import org.alfresco.cmis.mapping.BaseCMISTest;
import org.alfresco.cmis.renditions.CMISRenditionImpl;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISRenditionServiceTest
extends BaseCMISTest {
    private static final String[] THUMBNAIL_NAMES = new String[]{"doclib", "webpreview", "imgpreview"};
    private static final String[] THUMBNAIL_KINDS = new String[]{"cmis:thumbnail", "alf:webpreview", "alf:webpreview"};
    private NodeRef document;
    private List<CMISRendition> documentRenditions = new ArrayList<CMISRendition>();
    private CMISRendition icon16Rendition = new CMISRenditionImpl(null, "alf:icon16", "image/gif", "alf:icon16", 16, 16, null, null, null);
    private CMISRendition icon32Rendition = new CMISRenditionImpl(null, "alf:icon32", "image/gif", "alf:icon32", 32, 32, null, null, null);
    private Comparator<CMISRendition> renditionsComparator = new Comparator<CMISRendition>(){

        @Override
        public int compare(CMISRendition rendition1, CMISRendition rendition2) {
            return rendition1.getStreamId().compareTo(rendition2.getStreamId());
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String documentName = "TestDocument" + System.currentTimeMillis();
        this.document = this.createDocument(documentName, "Test Content", "application/pdf");
        this.documentRenditions = new ArrayList<CMISRendition>();
        for (int i = 0; i < THUMBNAIL_NAMES.length; ++i) {
            this.documentRenditions.add(this.createRendition(this.document, THUMBNAIL_NAMES[i], THUMBNAIL_KINDS[i]));
        }
    }

    public void testGetAllRenditions() throws Exception {
        List<CMISRendition> receivedRenditions = this.cmisRenditionService.getRenditions(this.document, "*");
        ArrayList<CMISRendition> expectedRenditions = new ArrayList<CMISRendition>();
        expectedRenditions.addAll(this.documentRenditions);
        expectedRenditions.add(this.icon16Rendition);
        expectedRenditions.add(this.icon32Rendition);
        this.assertRendiions(receivedRenditions, expectedRenditions);
    }

    public void testGetRenditionsByKind() throws Exception {
        this.testGetRenditionsByKind("cmis:thumbnail");
        this.testGetRenditionsByKind("alf:webpreview");
        this.testGetRenditionsByKind("alf:icon16");
        this.testGetRenditionsByKind("alf:icon32");
        this.testGetRenditionsByKind("alf:webpreview", "alf:icon32");
        this.testGetRenditionsByKind("cmis:thumbnail", "alf:webpreview", "alf:icon16", "alf:icon32");
    }

    public void testGetRenditionsByMimetype() throws Exception {
        for (CMISRendition rendition : this.documentRenditions) {
            this.testGetRenditionsByMimetype(rendition.getMimeType());
        }
        this.testGetRenditionsByMimetype(this.icon16Rendition.getMimeType());
        this.testGetRenditionsByMimetype(this.icon32Rendition.getMimeType());
        String[] mimetypes = this.getDifferentMimetypes();
        this.testGetRenditionsByMimetype(mimetypes);
    }

    public void testEmptyFilter() throws Exception {
        List<CMISRendition> receivedRenditions = this.cmisRenditionService.getRenditions(this.document, null);
        CMISRenditionServiceTest.assertTrue((receivedRenditions == null || receivedRenditions.size() == 0 ? 1 : 0) != 0);
        receivedRenditions = this.cmisRenditionService.getRenditions(this.document, "cmis:none");
        CMISRenditionServiceTest.assertTrue((receivedRenditions == null || receivedRenditions.size() == 0 ? 1 : 0) != 0);
    }

    public void testRenditionsByBaseMimetype() throws Exception {
        String[] mimetypes = this.getDifferentMimetypes();
        ArrayList<String> baseMimetypeFilters = new ArrayList<String>();
        for (String mimetype : mimetypes) {
            String baseMimetype = this.getBaseType(mimetype);
            String filter = baseMimetype + "/*";
            baseMimetypeFilters.add(filter);
            this.testGetRenditionsByMimetype(filter);
        }
        this.testGetRenditionsByMimetype(baseMimetypeFilters.toArray(new String[0]));
    }

    public void testMixedFilter() throws Exception {
        String[] mimetypes = this.getDifferentMimetypes();
        this.testGetRenditions(THUMBNAIL_KINDS, mimetypes);
    }

    private void testGetRenditionsByMimetype(String ... mimetypes) throws Exception {
        this.testGetRenditions(null, mimetypes);
    }

    private void testGetRenditionsByKind(String ... kinds) throws Exception {
        this.testGetRenditions(kinds, null);
    }

    private void testGetRenditions(String[] kinds, String[] mimetypes) throws Exception {
        String filter = this.createFilter(kinds, mimetypes);
        List<CMISRendition> receivedRenditions = this.cmisRenditionService.getRenditions(this.document, filter);
        ArrayList<CMISRendition> expectedRenditions = new ArrayList<CMISRendition>();
        if (kinds != null) {
            for (String kind : kinds) {
                expectedRenditions.addAll(this.getRenditionsByKind(kind));
            }
        }
        if (mimetypes != null) {
            for (String mimetype : mimetypes) {
                expectedRenditions.addAll(this.getRenditionsByMimetype(mimetype));
            }
        }
        this.assertRendiions(receivedRenditions, expectedRenditions);
    }

    @Override
    protected void tearDown() throws Exception {
        this.fileFolderService.delete(this.document);
        super.tearDown();
    }

    private CMISRendition createRendition(NodeRef nodeRef, String thumbnailName, String kind) {
        ThumbnailDefinition details = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinition(thumbnailName);
        NodeRef thumbnailNodeRef = this.thumbnailService.createThumbnail(nodeRef, ContentModel.PROP_CONTENT, details.getMimetype(), details.getTransformationOptions(), details.getName());
        CMISRenditionImpl rendition = new CMISRenditionImpl();
        rendition.setStreamId(thumbnailNodeRef.toString());
        rendition.setKind(kind);
        rendition.setMimeType(details.getMimetype());
        if (details.getTransformationOptions() instanceof ImageTransformationOptions) {
            ImageTransformationOptions imageOptions = (ImageTransformationOptions)details.getTransformationOptions();
            rendition.setWidth(imageOptions.getResizeOptions().getWidth());
            rendition.setHeight(imageOptions.getResizeOptions().getHeight());
        }
        return rendition;
    }

    private NodeRef createDocument(String documentName, String documentContent, String mimetype) {
        NodeRef textDocument = this.fileFolderService.create(this.rootNodeRef, "TEXT" + documentName, ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter contentWriter = this.fileFolderService.getWriter(textDocument);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        contentWriter.setLocale(Locale.ENGLISH);
        contentWriter.putContent(documentContent);
        ContentReader contentReader = this.fileFolderService.getReader(textDocument);
        NodeRef document = this.fileFolderService.create(this.rootNodeRef, documentName, ContentModel.TYPE_CONTENT).getNodeRef();
        contentWriter = this.fileFolderService.getWriter(document);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype(mimetype);
        contentWriter.setLocale(Locale.ENGLISH);
        if (this.contentService.isTransformable(contentReader, contentWriter)) {
            this.contentService.transform(contentReader, contentWriter);
        }
        this.fileFolderService.delete(textDocument);
        return document;
    }

    private void assertRendiions(List<CMISRendition> receivedRenditions, List<CMISRendition> expectedRenditions) {
        CMISRenditionServiceTest.assertNotNull(receivedRenditions);
        expectedRenditions = this.removeReplication(expectedRenditions);
        CMISRenditionServiceTest.assertTrue((receivedRenditions.size() == expectedRenditions.size() ? 1 : 0) != 0);
        for (CMISRendition rendition : receivedRenditions) {
            CMISRenditionServiceTest.assertNotNull((Object)rendition);
            CMISRenditionServiceTest.assertNotNull((Object)rendition.getStreamId());
        }
        Collections.sort(receivedRenditions, this.renditionsComparator);
        Collections.sort(expectedRenditions, this.renditionsComparator);
        for (int i = 0; i < expectedRenditions.size(); ++i) {
            this.assertRendition(receivedRenditions.get(i), expectedRenditions.get(i));
        }
    }

    private void assertRendition(CMISRendition receivedRendition, CMISRendition expectedRendition) {
        CMISRenditionServiceTest.assertEquals((String)expectedRendition.getStreamId(), (String)receivedRendition.getStreamId());
        CMISRenditionServiceTest.assertEquals((String)expectedRendition.getKind(), (String)receivedRendition.getKind());
        CMISRenditionServiceTest.assertEquals((String)expectedRendition.getMimeType(), (String)receivedRendition.getMimeType());
        CMISRenditionServiceTest.assertEquals((Object)expectedRendition.getWidth(), (Object)receivedRendition.getWidth());
        CMISRenditionServiceTest.assertEquals((Object)expectedRendition.getHeight(), (Object)receivedRendition.getHeight());
    }

    private List<CMISRendition> removeReplication(List<CMISRendition> renditions) {
        return new ArrayList<CMISRendition>(new HashSet<CMISRendition>(renditions));
    }

    private List<CMISRendition> getRenditionsByKind(String kind) {
        return this.getRenditions(kind, null);
    }

    private List<CMISRendition> getRenditionsByMimetype(String mimetype) {
        return this.getRenditions(null, mimetype);
    }

    private List<CMISRendition> getRenditions(String kind, String mimetype) {
        ArrayList<CMISRendition> result = new ArrayList<CMISRendition>();
        ArrayList<CMISRendition> allRenditions = new ArrayList<CMISRendition>(this.documentRenditions);
        allRenditions.add(this.icon16Rendition);
        allRenditions.add(this.icon32Rendition);
        for (CMISRendition rendition : allRenditions) {
            if (!this.isRenditionSatisfyConditions(rendition, kind, mimetype)) continue;
            result.add(rendition);
        }
        return result;
    }

    private boolean isRenditionSatisfyConditions(CMISRendition rendition, String kind, String mimetype) {
        if (kind != null && !kind.equals(rendition.getKind())) {
            return false;
        }
        if (mimetype != null) {
            if (mimetype.endsWith("/*")) {
                String baseMimetype = this.getBaseType(mimetype);
                if (!rendition.getMimeType().startsWith(baseMimetype)) {
                    return false;
                }
            } else if (!mimetype.equals(rendition.getMimeType())) {
                return false;
            }
        }
        return true;
    }

    private String[] getDifferentMimetypes() {
        ArrayList<CMISRendition> allRenditions = new ArrayList<CMISRendition>(this.documentRenditions);
        allRenditions.add(this.icon16Rendition);
        allRenditions.add(this.icon32Rendition);
        HashSet<String> mimetypes = new HashSet<String>();
        for (CMISRendition rendition : allRenditions) {
            mimetypes.add(rendition.getMimeType());
        }
        return mimetypes.toArray(new String[0]);
    }

    private String getBaseType(String mimetype) {
        String baseMymetype = mimetype;
        int subTypeIndex = mimetype.indexOf("/");
        if (subTypeIndex > 0 || subTypeIndex < mimetype.length()) {
            baseMymetype = mimetype.substring(0, subTypeIndex);
        }
        return baseMymetype;
    }

    private String createFilter(String[] kinds, String[] mimetypes) {
        StringBuilder filter = new StringBuilder();
        if (kinds != null) {
            for (String kind : kinds) {
                filter.append(kind);
                filter.append(",");
            }
        }
        if (mimetypes != null) {
            for (String mimetype : mimetypes) {
                filter.append(mimetype);
                filter.append(",");
            }
        }
        filter.delete(filter.length() - 1, filter.length());
        return filter.toString();
    }
}

