/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.alfresco.service.cmr.email.EmailMessagePart;

public class EmailMessagePartImpl
implements EmailMessagePart {
    private static final long serialVersionUID = 779186820993301580L;
    private byte[] content;
    private String encoding;
    private String fileName;

    public EmailMessagePartImpl(String fileName, byte[] content) {
        this(fileName, null, content);
    }

    public EmailMessagePartImpl(String fileName, String encoding, byte[] content) {
        if (fileName == null) {
            throw new IllegalArgumentException("FileName cannot be null");
        }
        this.fileName = fileName;
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null");
        }
        this.content = content;
        this.encoding = encoding == null ? "utf8" : encoding;
    }

    public InputStream getContent() {
        return new ByteArrayInputStream(this.content);
    }

    public String getContentType() {
        return "text/plain";
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSize() {
        return this.content.length;
    }
}

