/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.auth.cifs;

import java.util.ArrayList;
import java.util.Hashtable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoClientInfo;
import org.alfresco.filesys.auth.PassthruServerFactory;
import org.alfresco.filesys.auth.cifs.CifsAuthenticatorBase;
import org.alfresco.jlan.server.SessionListener;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.AuthContext;
import org.alfresco.jlan.server.auth.AuthenticatorException;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.NTLanManAuthContext;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.TargetInfo;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.passthru.AuthenticateSession;
import org.alfresco.jlan.server.auth.passthru.PassthruDetails;
import org.alfresco.jlan.server.auth.passthru.PassthruServers;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataPacker;
import org.alfresco.jlan.util.HexDump;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

public class PassthruCifsAuthenticator
extends CifsAuthenticatorBase
implements SessionListener {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol.auth");
    public static final int DefaultSessionTmo = 5000;
    public static final int MinSessionTmo = 2000;
    public static final int MaxSessionTmo = 30000;
    public static final int MinCheckInterval = 10;
    public static final int MaxCheckInterval = 900;
    public static final long PassthruKeepAliveInterval = 60000L;
    private static final int NTLM_FLAGS = -1610612095;
    private PassthruServers m_passthruServers;
    private boolean m_localPassThruServers;
    private Hashtable<String, PassthruDetails> m_sessions = new Hashtable();

    public void setPassthruServers(PassthruServers servers) {
        this.m_passthruServers = servers;
    }

    public int authenticateShareConnect(ClientInfo client, SharedDevice share, String sharePwd, SrvSession sess) {
        return 2;
    }

    public int authenticateUser(final ClientInfo client, final SrvSession sess, int alg) {
        if (!(client instanceof AlfrescoClientInfo)) {
            return -1;
        }
        final AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
        if (client.isNullSession()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Null CIFS logon allowed, sess = " + sess.getUniqueId()));
            }
            return 0;
        }
        return this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

            @Override
            public Integer execute() throws Throwable {
                int authSts;
                block22: {
                    authSts = -1;
                    try {
                        if (alfClient.hasAuthenticationTicket() && client.getLogonType() != 2) {
                            PassthruCifsAuthenticator.this.getAuthenticationService().validate(alfClient.getAuthenticationTicket());
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Re-using existing authentication token");
                            }
                            return client.getLogonType() != 1 ? 0 : 0x10000000;
                        }
                        if (client.isGuest() || client.getUserName().equalsIgnoreCase(PassthruCifsAuthenticator.this.getGuestUserName())) {
                            if (!PassthruCifsAuthenticator.this.allowGuest()) {
                                return -1;
                            }
                            PassthruCifsAuthenticator.this.doGuestLogon(client, sess);
                            authSts = 0x10000000;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Authenticated user " + client.getUserName() + " sts=" + PassthruCifsAuthenticator.this.getStatusAsString(authSts)));
                            }
                            return authSts;
                        }
                        PassthruDetails passDetails = (PassthruDetails)PassthruCifsAuthenticator.this.m_sessions.get(sess.getUniqueId());
                        if (passDetails != null) {
                            AuthenticateSession authSess;
                            try {
                                authSess = passDetails.getAuthenticateSession();
                                authSess.doSessionSetup(client.getDomain(), client.getUserName(), null, client.getANSIPassword(), client.getPassword(), 0);
                                if (authSess.isGuest()) {
                                    if (PassthruCifsAuthenticator.this.allowGuest()) {
                                        PassthruCifsAuthenticator.this.doGuestLogon(client, sess);
                                        authSts = 0x10000000;
                                        if (logger.isDebugEnabled()) {
                                            logger.debug((Object)("Passthru authenticate user=" + client.getUserName() + ", GUEST"));
                                        }
                                    }
                                } else {
                                    String username = client.getUserName();
                                    PassthruCifsAuthenticator.this.getAuthenticationComponent().setCurrentUser(username);
                                    alfClient.setAuthenticationTicket(PassthruCifsAuthenticator.this.getAuthenticationService().getCurrentTicket());
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Setting current user using person " + PassthruCifsAuthenticator.this.getAuthenticationComponent().getCurrentUserName() + " (username " + username + ")"));
                                    }
                                    authSts = 0;
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)("Passthru authenticate user=" + client.getUserName() + ", FULL"));
                                    }
                                }
                            }
                            catch (AuthenticationException e) {
                                throw e;
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex);
                            }
                            if (sess instanceof SMBSrvSession) break block22;
                            PassthruCifsAuthenticator.this.m_sessions.remove(sess.getUniqueId());
                            try {
                                authSess = passDetails.getAuthenticateSession();
                                authSess.CloseSession();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                                }
                                break block22;
                            }
                            catch (Exception ex) {
                                logger.error((Object)"Passthru error closing session (auth user)", (Throwable)ex);
                            }
                            break block22;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("  No PassthruDetails for " + sess.getUniqueId()));
                        }
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)ex);
                        }
                        return -1;
                    }
                }
                return authSts;
            }
        });
    }

    public AuthContext getAuthContext(SMBSrvSession sess) {
        NTLanManAuthContext authCtx = null;
        try {
            AuthenticateSession authSess;
            String domain = this.mapClientAddressToDomain(sess.getRemoteAddress());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mapped client " + sess.getRemoteAddress() + " to domain " + domain));
            }
            if ((authSess = this.m_passthruServers.openSession(false, domain)) != null) {
                PassthruDetails passDetails = new PassthruDetails((SrvSession)sess, authSess);
                this.m_sessions.put(sess.getUniqueId(), passDetails);
                authCtx = new NTLanManAuthContext(authSess.getEncryptionKey());
                sess.setAuthenticationContext((AuthContext)authCtx);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Passthru sessId=" + authSess.getSessionId() + ", auth ctx=" + authCtx));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to open a passthru session, mapped domain = " + domain));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Passthru error getting challenge", (Throwable)ex);
        }
        return authCtx;
    }

    public void generateNegotiateResponse(SMBSrvSession sess, SMBSrvPacket respPkt, boolean extendedSecurity) throws AuthenticatorException {
        if (!extendedSecurity) {
            super.generateNegotiateResponse(sess, respPkt, extendedSecurity);
            return;
        }
        if ((respPkt.getFlags2() & 0x800) == 0) {
            respPkt.setFlags2(respPkt.getFlags2() + 2048);
        }
        int pos = respPkt.getByteOffset();
        byte[] buf = respPkt.getBuffer();
        UUID serverGUID = sess.getSMBServer().getServerGUID();
        System.arraycopy(serverGUID.getBytes(), 0, buf, pos, 16);
        respPkt.setByteCount((pos += 16) - respPkt.getByteOffset());
    }

    public void processSessionSetup(SMBSrvSession sess, SMBSrvPacket reqPkt) throws SMBSrvException {
        if (!reqPkt.checkPacketIsValid(12, 0)) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        if (reqPkt.getParameterCount() == 13) {
            super.processSessionSetup(sess, reqPkt);
            return;
        }
        int maxBufSize = reqPkt.getParameter(2);
        int maxMpx = reqPkt.getParameter(3);
        int vcNum = reqPkt.getParameter(4);
        int secBlobLen = reqPkt.getParameter(7);
        int capabs = reqPkt.getParameterLong(10);
        int dataPos = reqPkt.getByteOffset();
        byte[] buf = reqPkt.getBuffer();
        boolean isUni = reqPkt.isUnicode();
        int secBlobPos = dataPos;
        reqPkt.setPosition(dataPos += secBlobLen);
        String domain = "";
        if (reqPkt.hasMoreData() && (domain = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        String clientOS = "";
        if (reqPkt.hasMoreData() && (clientOS = reqPkt.unpackString(isUni)) == null) {
            throw new SMBSrvException(-1073741811, 1, 2);
        }
        sess.setClientMaximumBufferSize(maxBufSize != 0 ? maxBufSize : 65540);
        sess.setClientMaximumMultiplex(maxMpx);
        sess.setClientCapabilities(capabs);
        AlfrescoClientInfo client = new AlfrescoClientInfo();
        client.setDomain(domain);
        client.setOperatingSystem(clientOS);
        client.setLogonType(0);
        if (sess.hasRemoteAddress()) {
            client.setClientAddress(sess.getRemoteAddress().getHostAddress());
        }
        client.setProcessId(reqPkt.getProcessId());
        Object setupObj = sess.getSetupObject(client.getProcessId());
        byte[] respBlob = null;
        boolean isNTLMSSP = false;
        try {
            if (secBlobLen >= NTLM.Signature.length) {
                int idx;
                for (idx = 0; idx < NTLM.Signature.length && buf[secBlobPos + idx] == NTLM.Signature[idx]; ++idx) {
                }
                if (idx == NTLM.Signature.length) {
                    isNTLMSSP = true;
                }
            }
            if (isNTLMSSP) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("NT Session setup NTLMSSP, MID=" + reqPkt.getMultiplexId() + ", UID=" + reqPkt.getUserId() + ", PID=" + reqPkt.getProcessId()));
                }
            } else {
                throw new SMBSrvException(-1073741811, 1, 2);
            }
            respBlob = this.doNtlmsspSessionSetup(sess, client, buf, secBlobPos, secBlobLen, isUni);
        }
        catch (SMBSrvException ex) {
            sess.removeSetupObject(client.getProcessId());
            throw ex;
        }
        if (logger.isDebugEnabled() && sess.hasDebug(32)) {
            logger.debug((Object)("User " + client.getUserName() + " logged on " + (client != null ? " (type " + client.getLogonTypeString() + ")" : "")));
        }
        if (sess.getClientInformation() == null || sess.getClientInformation().getUserName().length() == 0) {
            sess.setClientInformation((ClientInfo)client);
        }
        int respLen = respBlob != null ? respBlob.length : 0;
        boolean loggedOn = false;
        if (isNTLMSSP || sess.hasSetupObject(client.getProcessId()) || setupObj != null) {
            if (sess.hasSetupObject(client.getProcessId())) {
                reqPkt.setLongErrorCode(-1073741802);
            } else {
                reqPkt.setLongErrorCode(0);
                loggedOn = true;
            }
            reqPkt.setParameterCount(4);
            reqPkt.setParameter(0, 255);
            reqPkt.setParameter(1, 0);
            reqPkt.setParameter(2, 0);
            reqPkt.setParameter(3, respLen);
        } else {
            reqPkt.setLongErrorCode(0);
            reqPkt.setParameterCount(12);
            reqPkt.setParameter(0, 255);
            reqPkt.setParameter(1, 0);
            reqPkt.setParameter(2, 65540);
            reqPkt.setParameter(3, 4);
            reqPkt.setParameter(4, 0);
            reqPkt.setParameterLong(5, 0);
            reqPkt.setParameter(7, respLen);
            reqPkt.setParameterLong(8, 0);
            reqPkt.setParameterLong(10, this.getServerCapabilities());
            loggedOn = true;
        }
        int uid = 0;
        if (loggedOn) {
            sess.removeSetupObject(client.getProcessId());
            this.checkForAdminUserName(client);
            this.getHomeFolderForUser(client);
            VirtualCircuit vc = new VirtualCircuit(vcNum, (ClientInfo)client);
            uid = sess.addVirtualCircuit(vc);
            if (uid == -1) {
                if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                    logger.debug((Object)("Failed to allocate UID for virtual circuit, " + vc));
                }
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (logger.isDebugEnabled() && sess.hasDebug(32)) {
                logger.debug((Object)("Allocated UID=" + uid + " for VC=" + vc));
            }
        }
        reqPkt.setCommand(reqPkt.getCommand());
        reqPkt.setByteCount(0);
        reqPkt.setTreeId(0);
        reqPkt.setUserId(uid);
        int flags = reqPkt.getFlags();
        reqPkt.setFlags(flags &= 0xFFFFFFF7);
        int flags2 = 18433;
        if (isUni) {
            flags2 += 32768;
        }
        reqPkt.setFlags2(flags2);
        int pos = reqPkt.getByteOffset();
        buf = reqPkt.getBuffer();
        if (respBlob != null) {
            System.arraycopy(respBlob, 0, buf, pos, respBlob.length);
            pos += respBlob.length;
        }
        if (isUni) {
            pos = DataPacker.wordAlign((int)pos);
        }
        pos = DataPacker.putString((String)"Java", (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)("Alfresco CIFS Server " + sess.getServer().isVersion()), (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        pos = DataPacker.putString((String)this.getCIFSConfig().getDomainName(), (byte[])buf, (int)pos, (boolean)true, (boolean)isUni);
        reqPkt.setByteCount(pos - reqPkt.getByteOffset());
    }

    private final byte[] doNtlmsspSessionSetup(SMBSrvSession sess, ClientInfo client, byte[] secbuf, int secpos, int seclen, boolean unicode) throws SMBSrvException {
        int msgType = NTLMMessage.isNTLMType((byte[])secbuf, (int)secpos);
        byte[] respBlob = null;
        if (msgType == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Invalid NTLMSSP token received");
                logger.debug((Object)("  Token=" + HexDump.hexString((byte[])secbuf, (int)secpos, (int)seclen, (String)" ")));
            }
            throw new SMBSrvException(-1073741715, 5, 1);
        }
        if (msgType == 1) {
            Type1NTLMMessage type1Msg = new Type1NTLMMessage(secbuf, secpos, seclen);
            int ntlmFlags = type1Msg.getFlags() & 0xA0000281;
            NTLanManAuthContext ntlmCtx = (NTLanManAuthContext)this.getAuthContext(sess);
            String domain = sess.getSMBServer().getServerName();
            ArrayList<TargetInfo> tList = new ArrayList<TargetInfo>();
            tList.add(new TargetInfo(2, domain));
            tList.add(new TargetInfo(1, sess.getServerName()));
            tList.add(new TargetInfo(4, domain));
            tList.add(new TargetInfo(3, domain));
            ntlmFlags = -1065221627;
            Type2NTLMMessage type2Msg = new Type2NTLMMessage();
            type2Msg.buildType2(ntlmFlags, domain, ntlmCtx.getChallenge(), null, tList);
            sess.setSetupObject(client.getProcessId(), (Object)type2Msg);
            respBlob = type2Msg.getBytes();
        } else if (msgType == 3) {
            Type3NTLMMessage type3Msg = new Type3NTLMMessage(secbuf, secpos, seclen, unicode);
            if (!sess.hasSetupObject(client.getProcessId()) || !(sess.getSetupObject(client.getProcessId()) instanceof Type2NTLMMessage)) {
                sess.removeSetupObject(client.getProcessId());
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            if (type3Msg.hasFlag(0x20000000) && type3Msg.hasFlag(524288)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Received NTLMSSP/NTLMv2, not supported");
                }
                throw new SMBSrvException(-1073741715, 5, 1);
            }
            this.doNTLMv1Logon(sess, client, type3Msg);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Logged on using NTLMSSP/NTLMv1");
            }
        }
        return respBlob;
    }

    private final void doNTLMv1Logon(SMBSrvSession sess, final ClientInfo client, Type3NTLMMessage type3Msg) throws SMBSrvException {
        sess.removeSetupObject(client.getProcessId());
        final String userName = type3Msg.getUserName();
        if (userName.length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Null logon");
            }
            client.setLogonType(2);
            return;
        }
        PassthruDetails passDetails = this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.doSessionSetup(type3Msg.getDomain(), userName, null, type3Msg.getLMHash(), type3Msg.getNTLMHash(), 0);
                if (authSess.isGuest()) {
                    if (this.allowGuest()) {
                        this.doGuestLogon(client, (SrvSession)sess);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Passthru authenticate user=" + userName + ", GUEST"));
                        }
                    }
                } else {
                    this.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            NodeRef userNode = PassthruCifsAuthenticator.this.getPersonService().getPerson(userName);
                            if (userNode != null) {
                                String personName = (String)((Object)PassthruCifsAuthenticator.this.getNodeService().getProperty(userNode, ContentModel.PROP_USERNAME));
                                PassthruCifsAuthenticator.this.getAuthenticationComponent().setCurrentUser(personName);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Setting current user using person " + personName + " (username " + userName + ")"));
                                }
                            } else {
                                PassthruCifsAuthenticator.this.getAuthenticationComponent().setCurrentUser(userName);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Setting current user using username " + userName));
                                }
                            }
                            AlfrescoClientInfo alfClient = (AlfrescoClientInfo)client;
                            alfClient.setAuthenticationTicket(PassthruCifsAuthenticator.this.getAuthenticationService().getCurrentTicket());
                            client.setLogonType(0);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Passthru authenticate user=" + userName + ", FULL"));
                            }
                            return null;
                        }
                    });
                }
                client.setDomain(type3Msg.getDomain());
                client.setUserName(userName);
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                throw new SMBSrvException(6, -1073741715);
            }
            finally {
                this.m_sessions.remove(sess.getUniqueId());
                try {
                    AuthenticateSession authSess = passDetails.getAuthenticateSession();
                    authSess.CloseSession();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Passthru error closing session (auth user)", (Throwable)ex);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  No PassthruDetails for " + sess.getUniqueId() + ", check server list/domain mappings"));
        }
        throw new SMBSrvException(6, -1073741715);
    }

    protected boolean validateAuthenticationMode() {
        AuthenticationComponent authenticationComponent = this.getAuthenticationComponent();
        return !(authenticationComponent instanceof NLTMAuthenticator) || ((NLTMAuthenticator)authenticationComponent).getNTLMMode() != NTLMMode.MD4_PROVIDER;
    }

    public void initialize(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        ConfigElement protoOrderElem;
        ConfigElement domNameElem;
        ConfigElement srvNamesElem;
        ConfigElement sessTmoElem;
        PassthruServerFactory factory = new PassthruServerFactory();
        ConfigElement checkInterval = params.getChild("offlineCheckInterval");
        if (checkInterval != null) {
            try {
                factory.setOfflineCheckInterval(Integer.parseInt(checkInterval.getValue()));
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid offline check interval specified");
            }
        }
        if ((sessTmoElem = params.getChild("Timeout")) != null) {
            try {
                factory.setTimeout(Integer.parseInt(sessTmoElem.getValue()));
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid timeout value specified");
            }
        }
        if (params.getChild("LocalServer") != null) {
            String server = this.getCIFSConfig().getServerName();
            if (server == null) {
                throw new AlfrescoRuntimeException("Passthru authenticator failed to get local server name");
            }
            factory.setServer(server);
        }
        if ((srvNamesElem = params.getChild("Server")) != null && srvNamesElem.getValue().length() > 0) {
            factory.setServer(srvNamesElem.getValue());
        }
        if (params.getChild("LocalDomain") != null) {
            factory.setDomain(this.getCIFSConfig().getDomainName());
        }
        if ((domNameElem = params.getChild("Domain")) != null && domNameElem.getValue().length() > 0) {
            factory.setDomain(domNameElem.getValue());
        }
        if ((protoOrderElem = params.getChild("ProtocolOrder")) != null && protoOrderElem.getValue().length() > 0) {
            factory.setProtocolOrder(protoOrderElem.getValue());
        }
        factory.afterPropertiesSet();
        this.setPassthruServers((PassthruServers)factory.getObject());
        this.m_localPassThruServers = true;
        super.initialize(config, params);
        SMBServer smbServer = (SMBServer)config.findServer("SMB");
        if (smbServer != null) {
            smbServer.addSessionListener((SessionListener)this);
        }
    }

    public int getServerCapabilities() {
        return -2147433860;
    }

    public void closeAuthenticator() {
        if (this.m_localPassThruServers && this.m_passthruServers != null) {
            this.m_passthruServers.shutdown();
        }
    }

    public void sessionClosed(SrvSession sess) {
        PassthruDetails passDetails = this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            this.m_sessions.remove(sess.getUniqueId());
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.CloseSession();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Passthru error closing session (closed)", (Throwable)ex);
            }
        }
    }

    public void sessionCreated(SrvSession sess) {
    }

    public void sessionLoggedOn(SrvSession sess) {
        ClientInfo cInfo = sess.getClientInformation();
        if (cInfo == null || cInfo.isNullSession()) {
            return;
        }
        PassthruDetails passDetails = this.m_sessions.get(sess.getUniqueId());
        if (passDetails != null) {
            this.m_sessions.remove(sess.getUniqueId());
            try {
                AuthenticateSession authSess = passDetails.getAuthenticateSession();
                authSess.CloseSession();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closed auth session, sessId=" + authSess.getSessionId()));
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Passthru error closing session (logon)", (Throwable)ex);
            }
        }
    }
}

