/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.dictionary;

import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.alfresco.jcr.dictionary.NodeTypeManagerImpl;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;

public class NodeDefinitionImpl
implements NodeDefinition {
    private NodeTypeManagerImpl typeManager;
    private ChildAssociationDefinition assocDef;

    public NodeDefinitionImpl(NodeTypeManagerImpl typeManager, ChildAssociationDefinition assocDef) {
        this.typeManager = typeManager;
        this.assocDef = assocDef;
    }

    public NodeType[] getRequiredPrimaryTypes() {
        ClassDefinition target = this.assocDef.getTargetClass();
        return new NodeType[]{this.typeManager.getNodeTypeImpl(target.getName())};
    }

    public NodeType getDefaultPrimaryType() {
        return null;
    }

    public boolean allowsSameNameSiblings() {
        return this.assocDef.getDuplicateChildNamesAllowed();
    }

    public NodeType getDeclaringNodeType() {
        return this.typeManager.getNodeTypeImpl(this.assocDef.getSourceClass().getName());
    }

    public String getName() {
        return this.assocDef.getName().toPrefixString((NamespacePrefixResolver)this.typeManager.getNamespaceService());
    }

    public boolean isAutoCreated() {
        return this.isMandatory();
    }

    public boolean isMandatory() {
        return this.assocDef.isTargetMandatory();
    }

    public int getOnParentVersion() {
        return 3;
    }

    public boolean isProtected() {
        return this.assocDef.isProtected();
    }
}

