/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.item;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.alfresco.jcr.item.JCRPath;
import org.alfresco.jcr.item.NodeImpl;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRTypeConverter {
    private SessionTypeConverter jcrTypeConverter;

    public JCRTypeConverter(SessionImpl session) {
        this.jcrTypeConverter = new SessionTypeConverter(session);
    }

    public TypeConverter getConverter() {
        return this.jcrTypeConverter;
    }

    public NodeImpl referenceValue(Object value) throws ValueFormatException, RepositoryException {
        NodeRef nodeRef = this.convert(NodeRef.class, value);
        return new NodeImpl(this.jcrTypeConverter.getSession(), nodeRef);
    }

    public String stringValue(Object value) throws ValueFormatException, RepositoryException {
        return this.convert(String.class, value);
    }

    public InputStream streamValue(Object value) throws IllegalStateException, RepositoryException {
        return this.convert(InputStream.class, value);
    }

    public long longValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        try {
            return this.jcrTypeConverter.longValue(value);
        }
        catch (Exception e) {
            JCRTypeConverter.translateException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public double doubleValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        try {
            return this.jcrTypeConverter.doubleValue(value);
        }
        catch (Exception e) {
            JCRTypeConverter.translateException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public Calendar dateValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        Date date = this.convert(Date.class, value);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public boolean booleanValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        try {
            return this.jcrTypeConverter.booleanValue(value);
        }
        catch (Exception e) {
            JCRTypeConverter.translateException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public QName nameValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.convert(QName.class, value);
    }

    public Path pathValue(Object value) throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.convert(Path.class, value);
    }

    public final Object convert(DataTypeDefinition propertyType, Object value) throws RepositoryException {
        try {
            return this.jcrTypeConverter.convert(propertyType, value);
        }
        catch (Exception e) {
            JCRTypeConverter.translateException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    public final <T> T convert(Class<T> c, Object value) throws RepositoryException {
        try {
            return (T)this.jcrTypeConverter.convert(c, value);
        }
        catch (Exception e) {
            JCRTypeConverter.translateException(e);
            throw new RepositoryException((Throwable)e);
        }
    }

    private static void translateException(Exception e) throws ValueFormatException {
        if (e instanceof TypeConversionException || e instanceof NumberFormatException) {
            throw new ValueFormatException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SessionTypeConverter
    extends TypeConverter {
        private SessionImpl session;

        public SessionTypeConverter(SessionImpl session) {
            this.session = session;
            this.addConverter(String.class, QName.class, (TypeConverter.Converter)new TypeConverter.Converter<String, QName>(){

                public QName convert(String source) {
                    try {
                        return QName.createQName((String)source, (NamespacePrefixResolver)SessionTypeConverter.this.session.getNamespaceResolver());
                    }
                    catch (NamespaceException e) {
                        throw new TypeConversionException("Cannot convert " + source + " to qualified name", (Throwable)e);
                    }
                }
            });
            this.addConverter(String.class, Path.class, (TypeConverter.Converter)new TypeConverter.Converter<String, Path>(){

                public Path convert(String source) {
                    try {
                        return new JCRPath(SessionTypeConverter.this.session.getNamespaceResolver(), source).getPath();
                    }
                    catch (NamespaceException e) {
                        throw new TypeConversionException("Cannot convert " + source + " to qualified name", (Throwable)e);
                    }
                }
            });
            this.addConverter(QName.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<QName, String>(){

                public String convert(QName source) {
                    try {
                        return source.toPrefixString(SessionTypeConverter.this.session.getNamespaceResolver());
                    }
                    catch (NamespaceException e) {
                        throw new TypeConversionException("Cannot convert " + source + " to qualified name", (Throwable)e);
                    }
                }
            });
            this.addConverter(Path.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<Path, String>(){

                public String convert(Path source) {
                    try {
                        return source.toPrefixString(SessionTypeConverter.this.session.getNamespaceResolver());
                    }
                    catch (NamespaceException e) {
                        throw new TypeConversionException("Cannot convert " + source + " to qualified name", (Throwable)e);
                    }
                }
            });
            this.addConverter(NodeRef.class, String.class, (TypeConverter.Converter)new TypeConverter.Converter<NodeRef, String>(){

                public String convert(NodeRef source) {
                    return source.getId();
                }
            });
        }

        public SessionImpl getSession() {
            return this.session;
        }

        public <F, T> TypeConverter.Converter getConverter(Class<F> source, Class<T> dest) {
            TypeConverter.Converter converter = super.getConverter(source, dest);
            if (converter == null && (converter = DefaultTypeConverter.INSTANCE.getConverter(source, dest)) instanceof TypeConverter.DynamicTwoStageConverter) {
                TypeConverter.DynamicTwoStageConverter dynamic = (TypeConverter.DynamicTwoStageConverter)converter;
                converter = this.addDynamicTwoStageConverter(dynamic.getFrom(), dynamic.getIntermediate(), dynamic.getTo());
            }
            return converter;
        }
    }
}

