/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.query;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.version.VersionException;
import org.alfresco.jcr.session.SessionImpl;
import org.alfresco.jcr.util.JCRProxyFactory;

public abstract class QueryImpl
implements Query {
    private SessionImpl session;
    private String statement;
    private Query proxy = null;

    public QueryImpl(SessionImpl session, String statement) {
        this.session = session;
        this.statement = statement;
    }

    public Query getProxy() {
        if (this.proxy == null) {
            this.proxy = (Query)JCRProxyFactory.create(this, Query.class, this.session);
        }
        return this.proxy;
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public abstract void isValidStatement() throws InvalidQueryException;

    public String getStatement() {
        return this.statement;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException("This query has not been saved to the Repository");
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }
}

