/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceTransport;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionServiceTransportImpl
implements ActionServiceTransport {
    private ActionService fActionService;
    private AuthenticationService fAuthenticationService;

    public void setActionService(ActionService service) {
        this.fActionService = service;
    }

    public void setAuthenticationService(AuthenticationService service) {
        this.fAuthenticationService = service;
    }

    @Override
    public Action createAction(String ticket, String name) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.createAction(name);
    }

    @Override
    public Action createAction(String ticket, String name, Map<String, Serializable> params) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.createAction(name, params);
    }

    @Override
    public ActionCondition createActionCondition(String ticket, String name) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.createActionCondition(name);
    }

    @Override
    public ActionCondition createActionCondition(String ticket, String name, Map<String, Serializable> params) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.createActionCondition(name, params);
    }

    @Override
    public CompositeAction createCompositeAction(String ticket) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.createCompositeAction();
    }

    @Override
    public boolean evaluateAction(String ticket, Action action, NodeRef actionedUponNodeRef) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.evaluateAction(action, actionedUponNodeRef);
    }

    @Override
    public boolean evaluateActionCondition(String ticket, ActionCondition condition, NodeRef actionedUponNodeRef) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.evaluateActionCondition(condition, actionedUponNodeRef);
    }

    @Override
    public void executeAction(String ticket, Action action, NodeRef actionedUponNodeRef) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.executeAction(action, actionedUponNodeRef);
    }

    @Override
    public void executeAction(String ticket, Action action, NodeRef actionedUponNodeRef, boolean checkConditions) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.executeAction(action, actionedUponNodeRef, checkConditions);
    }

    @Override
    public void executeAction(String ticket, Action action, NodeRef actionedUponNodeRef, boolean checkConditions, boolean executeAsynchronously) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.executeAction(action, actionedUponNodeRef, checkConditions, executeAsynchronously);
    }

    @Override
    public Action getAction(String ticket, NodeRef nodeRef, String actionId) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getAction(nodeRef, actionId);
    }

    @Override
    public ActionConditionDefinition getActionConditionDefinition(String ticket, String name) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActionConditionDefinition(name);
    }

    @Override
    public List<ActionConditionDefinition> getActionConditionDefinitions(String ticket) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActionConditionDefinitions();
    }

    @Override
    public ActionDefinition getActionDefinition(String ticket, String name) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActionDefinition(name);
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(String ticket) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActionDefinitions();
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(String ticket, NodeRef nodeRef) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActionDefinitions(nodeRef);
    }

    @Override
    public ParameterConstraint getParameterConstraint(String ticket, String name) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getParameterConstraint(name);
    }

    @Override
    public List<ParameterConstraint> getParameterConstraints(String ticket) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getParameterConstraints();
    }

    @Override
    public List<Action> getActions(String ticket, NodeRef nodeRef) {
        this.fAuthenticationService.validate(ticket);
        return this.fActionService.getActions(nodeRef);
    }

    @Override
    public void removeAction(String ticket, NodeRef nodeRef, Action action) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.removeAction(nodeRef, action);
    }

    @Override
    public void removeAllActions(String ticket, NodeRef nodeRef) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.removeAllActions(nodeRef);
    }

    @Override
    public void saveAction(String ticket, NodeRef nodeRef, Action action) {
        this.fAuthenticationService.validate(ticket);
        this.fActionService.saveAction(nodeRef, action);
    }
}

