/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator.compare;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.evaluator.ComparePropertyValueEvaluator;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.PropertyValueComparator;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.util.ISO8601DateFormat;

public class DatePropertyValueComparator
implements PropertyValueComparator {
    private static final String MSGID_INVALID_OPERATION = "date_property_value_comparator.invalid_operation";

    public boolean compare(Serializable propertyValue, Serializable compareValue, ComparePropertyValueOperation operation) {
        boolean result = false;
        if (operation == null) {
            operation = ComparePropertyValueOperation.EQUALS;
        }
        Date propertyDate = this.getDate(propertyValue);
        Date compareDate = this.getDate(compareValue);
        switch (operation) {
            case EQUALS: {
                result = propertyDate.equals(compareDate);
                break;
            }
            case LESS_THAN: {
                result = propertyDate.before(compareDate);
                break;
            }
            case LESS_THAN_EQUAL: {
                result = propertyDate.equals(compareDate) || propertyDate.before(compareDate);
                break;
            }
            case GREATER_THAN: {
                result = propertyDate.after(compareDate);
                break;
            }
            case GREATER_THAN_EQUAL: {
                result = propertyDate.equals(compareDate) || propertyDate.after(compareDate);
                break;
            }
            default: {
                throw new ActionServiceException(MSGID_INVALID_OPERATION, new Object[]{operation.toString()});
            }
        }
        return result;
    }

    private Date getDate(Serializable value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof String) {
            return ISO8601DateFormat.parse((String)((String)((Object)value)));
        }
        throw new AlfrescoRuntimeException("Parameter 'compareValue' must be of type java.util.Date!");
    }

    public void registerComparator(ComparePropertyValueEvaluator evaluator) {
        evaluator.registerComparator(DataTypeDefinition.DATE, this);
        evaluator.registerComparator(DataTypeDefinition.DATETIME, this);
    }
}

