/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.scheduled;

import java.util.Date;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionServiceImplTest;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.action.scheduled.ScheduledPersistedActionImpl;
import org.alfresco.repo.action.scheduled.ScheduledPersistedActionServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.quartz.DateIntervalTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class ScheduledPersistedActionServiceTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private ScheduledPersistedActionServiceImpl.ScheduledPersistedActionServiceBootstrap bootstrap;
    private ScheduledPersistedActionService service;
    private ScheduledPersistedActionServiceImpl serviceImpl;
    private Scheduler scheduler;
    private TransactionService transactionService;
    private RuntimeActionService runtimeActionService;
    private ActionService actionService;
    private NodeService nodeService;
    private Action testAction;
    private Action testAction2;
    private Action testAction3;

    protected void setUp() throws Exception {
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionService");
        this.runtimeActionService = (RuntimeActionService)ctx.getBean("actionService");
        this.service = (ScheduledPersistedActionService)ctx.getBean("ScheduledPersistedActionService");
        this.serviceImpl = (ScheduledPersistedActionServiceImpl)ctx.getBean("scheduledPersistedActionService");
        this.scheduler = (Scheduler)ctx.getBean("schedulerFactory");
        this.bootstrap = (ScheduledPersistedActionServiceImpl.ScheduledPersistedActionServiceBootstrap)((Object)ctx.getBean("scheduledPersistedActionServiceBootstrap"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ActionServiceImplTest.SleepActionExecuter.registerIfNeeded(ctx);
        List<ScheduledPersistedAction> schedules = this.service.listSchedules();
        for (ScheduledPersistedAction schedule : schedules) {
            this.service.deleteSchedule(schedule);
        }
        this.testAction = new TestAction(this.actionService.createAction("sleep-action"));
        this.runtimeActionService.createActionNodeRef(this.testAction, ScheduledPersistedActionServiceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction"));
        this.testAction2 = new TestAction(this.actionService.createAction("sleep-action"));
        this.runtimeActionService.createActionNodeRef(this.testAction2, ScheduledPersistedActionServiceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction2"));
        this.testAction3 = new TestAction(this.actionService.createAction("sleep-action"));
        txn.commit();
        this.scheduler.standby();
    }

    protected void tearDown() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        List<ScheduledPersistedAction> schedules = this.service.listSchedules();
        for (ScheduledPersistedAction schedule : schedules) {
            this.service.deleteSchedule(schedule);
        }
        txn.commit();
        this.scheduler.start();
    }

    public void testPersistedActionImpl() throws Exception {
        ScheduledPersistedActionImpl schedule = new ScheduledPersistedActionImpl(this.testAction);
        ScheduledPersistedActionImpl schedule3 = new ScheduledPersistedActionImpl(this.testAction3);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction, (Object)schedule.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3, (Object)schedule3.getAction());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getActionNodeRef());
        this.runtimeActionService.createActionNodeRef(this.testAction3, ScheduledPersistedActionServiceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction3"));
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction, (Object)schedule.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3, (Object)schedule3.getAction());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction3.getNodeRef(), (Object)schedule3.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule3.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        schedule.setScheduleStart(new Date(1234L));
        ScheduledPersistedActionServiceTest.assertEquals((long)1234L, (long)schedule.getScheduleStart().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        schedule.setScheduleEnd(new Date(4321L));
        ScheduledPersistedActionServiceTest.assertEquals((long)1234L, (long)schedule.getScheduleStart().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)4321L, (long)schedule.getScheduleEnd().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule3.getScheduleEnd());
        schedule.setScheduleStart(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((long)4321L, (long)schedule.getScheduleEnd().getTime());
        schedule.setScheduleEnd(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleEnd());
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)((Object)schedule.getScheduleIntervalPeriod()));
        schedule.setScheduleIntervalCount(3);
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)((Object)schedule.getScheduleIntervalPeriod()));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        ScheduledPersistedActionServiceTest.assertEquals((String)"3Hour", (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Hour), (Object)((Object)schedule.getScheduleIntervalPeriod()));
        schedule.setScheduleIntervalCount(8);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        ScheduledPersistedActionServiceTest.assertEquals((String)"8Month", (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals((int)8, (int)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Month), (Object)((Object)schedule.getScheduleIntervalPeriod()));
        schedule.setScheduleIntervalCount(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Month), (Object)((Object)schedule.getScheduleIntervalPeriod()));
        schedule.setScheduleIntervalPeriod(null);
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)((Object)schedule.getScheduleIntervalPeriod()));
    }

    public void testActionToTrigger() throws Exception {
        ScheduledPersistedActionImpl schedule = (ScheduledPersistedActionImpl)this.service.createSchedule(this.testAction);
        try {
            schedule.asTrigger();
            ScheduledPersistedActionServiceTest.fail((String)"Should require persistence first");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.service.saveSchedule(schedule);
        schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (String)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)((Object)schedule.getScheduleIntervalPeriod()));
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)schedule.asTrigger());
        schedule.setScheduleStart(new Date(12345L));
        Trigger t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(SimpleTrigger.class, t.getClass());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(new Date(12345L));
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleIntervalCount(2);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(DateIntervalTrigger.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)((DateIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateIntervalTrigger.IntervalUnit.SECOND, (Object)((DateIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(null);
        schedule.setScheduleIntervalCount(3);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(DateIntervalTrigger.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)3, (int)((DateIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateIntervalTrigger.IntervalUnit.MONTH, (Object)((DateIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(54321L));
        schedule.setScheduleIntervalCount(12);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Week);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        long future = System.currentTimeMillis() + 1234567L;
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(12);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Week);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getEndTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(DateIntervalTrigger.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)12, (int)((DateIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateIntervalTrigger.IntervalUnit.WEEK, (Object)((DateIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(6);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)2.0);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getEndTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(DateIntervalTrigger.class, t.getClass());
        ScheduledPersistedActionServiceTest.assertEquals((int)6, (int)((DateIntervalTrigger)t).getRepeatInterval());
        ScheduledPersistedActionServiceTest.assertEquals((Object)DateIntervalTrigger.IntervalUnit.HOUR, (Object)((DateIntervalTrigger)t).getRepeatIntervalUnit());
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(54321L));
        schedule.setScheduleIntervalCount(null);
        schedule.setScheduleIntervalPeriod(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(new Date(12345L));
        schedule.setScheduleEnd(new Date(future));
        schedule.setScheduleIntervalCount(null);
        schedule.setScheduleIntervalPeriod(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)12345L, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        ScheduledPersistedActionServiceTest.assertEquals(SimpleTrigger.class, t.getClass());
    }

    public void testAsTriggerLastRun() throws Exception {
        long future = System.currentTimeMillis() + 1234567L;
        long future90mins = System.currentTimeMillis() + 5400000L;
        long past30mins = System.currentTimeMillis() - 1800000L;
        long past90mins = System.currentTimeMillis() - 5400000L;
        long past150mins = System.currentTimeMillis() - 9000000L;
        ScheduledPersistedActionImpl schedule = (ScheduledPersistedActionImpl)this.service.createSchedule(this.testAction);
        this.service.saveSchedule(schedule);
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        Trigger t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(null);
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((double)System.currentTimeMillis(), (double)t.getStartTime().getTime(), (double)10.0);
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past90mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t);
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(null);
        schedule.setScheduleIntervalCount(null);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(future));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(null);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past30mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past30mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past150mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past30mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)future90mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
        schedule.setScheduleStart(new Date(past150mins));
        schedule.setScheduleEnd(null);
        schedule.setScheduleLastExecutedAt(new Date(past90mins));
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Hour);
        schedule.setScheduleIntervalCount(2);
        t = schedule.asTrigger();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)t);
        ScheduledPersistedActionServiceTest.assertEquals((long)past150mins, (long)t.getStartTime().getTime());
        ScheduledPersistedActionServiceTest.assertEquals((long)future90mins, (long)t.getFireTimeAfter(new Date()).getTime());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)t.getEndTime());
    }

    public void testCreation() {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        ScheduledPersistedActionServiceTest.assertTrue((this.testAction == schedule.getAction() ? 1 : 0) != 0);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)schedule.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleInterval());
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertNull((Object)((Object)schedule.getScheduleIntervalPeriod()));
        Date now = new Date();
        schedule.setScheduleStart(now);
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)schedule.getScheduleStart());
        schedule.setScheduleIntervalCount(2);
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(2), (Object)schedule.getScheduleIntervalCount());
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)schedule.getScheduleIntervalPeriod()));
    }

    public void testCreateSaveLoad() throws Exception {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        Date now = new Date();
        schedule.setScheduleStart(now);
        schedule.setScheduleIntervalCount(2);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.service.saveSchedule(schedule);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionImpl retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(2), (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)retrieved.getScheduleIntervalPeriod()));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionImpl second = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)second);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)second.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)second.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(2), (Object)second.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)second.getScheduleIntervalPeriod()));
        schedule = this.service.createSchedule(this.testAction3);
        ScheduledPersistedActionServiceTest.assertNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.runtimeActionService.createActionNodeRef(this.testAction3, ScheduledPersistedActionServiceImpl.SCHEDULED_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestAction3"));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        this.service.saveSchedule(schedule);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule.getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
    }

    public void testEditing() throws Exception {
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule);
        Date now = new Date();
        schedule.setScheduleStart(now);
        schedule.setScheduleIntervalCount(2);
        schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Day);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule(schedule);
        txn.commit();
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        ScheduledPersistedActionImpl retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(2), (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)retrieved.getScheduleIntervalPeriod()));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule(schedule);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(2), (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)retrieved.getScheduleIntervalPeriod()));
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        retrieved.setScheduleIntervalCount(3);
        this.service.saveSchedule(retrieved);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(3), (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Day), (Object)((Object)retrieved.getScheduleIntervalPeriod()));
        retrieved.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Month);
        now = new Date();
        retrieved.setScheduleStart(now);
        txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.service.saveSchedule(retrieved);
        retrieved = this.serviceImpl.loadPersistentSchedule(((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getAction().getNodeRef());
        ScheduledPersistedActionServiceTest.assertEquals((Object)now, (Object)retrieved.getScheduleStart());
        ScheduledPersistedActionServiceTest.assertEquals((Object)new Integer(3), (Object)retrieved.getScheduleIntervalCount());
        ScheduledPersistedActionServiceTest.assertEquals((Object)((Object)SchedulableAction.IntervalPeriod.Month), (Object)((Object)retrieved.getScheduleIntervalPeriod()));
    }

    public void testLoadList() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule1);
        ScheduledPersistedAction schedule2 = this.service.createSchedule(this.testAction2);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.service.saveSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)this.service.listSchedules().get(0).getActionNodeRef());
        this.service.saveSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)this.service.listSchedules().size());
    }

    public void testLoadFromAction() throws Exception {
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)schedule1);
        this.service.saveSchedule(schedule1);
        ScheduledPersistedAction retrieved = this.service.getSchedule(this.testAction2);
        ScheduledPersistedActionServiceTest.assertNull((Object)retrieved);
        retrieved = this.service.getSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertNotNull((Object)retrieved);
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)retrieved.getActionNodeRef());
    }

    public void testStartup() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobNames("PersistedActions").length);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.bootstrap.onBootstrap(null);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobNames("PersistedActions").length);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        long future = System.currentTimeMillis() + 1234567L;
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        schedule.setScheduleStart(new Date(future));
        this.service.saveSchedule(schedule);
        ((ScheduledPersistedActionServiceImpl)ctx.getBean("scheduledPersistedActionService")).removeFromScheduler((ScheduledPersistedActionImpl)schedule);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobNames("PersistedActions").length);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        this.bootstrap.onBootstrap(null);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.scheduler.getJobNames("PersistedActions").length);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
    }

    public void testDeletion() throws Exception {
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule1 = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        this.service.deleteSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedAction schedule2 = this.service.createSchedule(this.testAction2);
        this.service.saveSchedule(schedule1);
        this.service.saveSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)2, (int)this.service.listSchedules().size());
        NodeRef schedule1NodeRef = ((ScheduledPersistedActionImpl)schedule1).getPersistedAtNodeRef();
        NodeRef schedule2NodeRef = ((ScheduledPersistedActionImpl)schedule2).getPersistedAtNodeRef();
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule1NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule2NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.deleteSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)this.service.listSchedules().get(0).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getTargetAssocs(schedule1NodeRef, RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.deleteSchedule(schedule2);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)this.service.listSchedules().get(0).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        this.service.deleteSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule1NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.serviceImpl.loadPersistentSchedule(schedule2NodeRef));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.nodeService.getSourceAssocs(this.testAction2.getNodeRef(), RegexQNamePattern.MATCH_ALL).size());
        this.service.saveSchedule(schedule1);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((Object)this.testAction.getNodeRef(), (Object)this.service.listSchedules().get(0).getActionNodeRef());
        ScheduledPersistedActionServiceTest.assertNotNull((Object)this.service.getSchedule(this.testAction));
        ScheduledPersistedActionServiceTest.assertNull((Object)this.service.getSchedule(this.testAction2));
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.nodeService.deleteNode(this.testAction.getNodeRef());
        txn.commit();
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.service.listSchedules().size());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)this.service.listSchedules().get(0).getAction());
        ScheduledPersistedActionServiceTest.assertEquals(null, (Object)this.service.listSchedules().get(0).getActionNodeRef());
    }

    public void testJobBeanInjection() throws Exception {
        this.scheduler.start();
        TestJob job = new TestJob();
        JobDetail details = new JobDetail("ThisIsATest", null, job.getClass());
        SimpleTrigger now = new SimpleTrigger("TestTrigger", new Date(1L));
        now.setMisfireInstruction(1);
        Scheduler scheduler = (Scheduler)ctx.getBean("schedulerFactory");
        scheduler.scheduleJob(details, (Trigger)now);
        for (int i = 0; i < 20; ++i) {
            if (TestJob.ran) continue;
            Thread.sleep(50L);
        }
        ScheduledPersistedActionServiceTest.assertEquals((boolean)true, (boolean)TestJob.ran);
        ScheduledPersistedActionServiceTest.assertEquals((boolean)true, (boolean)TestJob.gotContext);
    }

    public void testExecution() throws Exception {
        final ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.resetTimesExecuted();
        sleepActionExec.setSleepMs(1);
        this.scheduler.start();
        ScheduledPersistedAction schedule = this.service.createSchedule(this.testAction);
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobNames("PersistedActions").length);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() + 1000L));
                Assert.assertNull((Object)schedule.getScheduleInterval());
                Assert.assertNull((Object)schedule.getScheduleIntervalCount());
                Assert.assertNull((Object)((Object)schedule.getScheduleIntervalPeriod()));
                Assert.assertNull((Object)schedule.getScheduleLastExecutedAt());
                System.out.println("Job starts in 1 second, no repeat...");
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                return null;
            }
        }, false, true);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)this.scheduler.getJobNames("PersistedActions").length);
        Thread.sleep(2000L);
        ScheduledPersistedActionServiceTest.assertEquals((int)1, (int)sleepActionExec.getTimesExecuted());
        ScheduledPersistedActionServiceTest.assertEquals((int)0, (int)this.scheduler.getJobNames("PersistedActions").length);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                Assert.assertEquals((double)System.currentTimeMillis(), (double)schedule.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                Assert.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobNames("PersistedActions").length);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() - 50L));
                ((ScheduledPersistedActionImpl)schedule).setScheduleEnd(new Date(System.currentTimeMillis() + 3500L));
                schedule.setScheduleIntervalCount(2);
                schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                Assert.assertEquals((String)"2Second", (String)schedule.getScheduleInterval());
                sleepActionExec.resetTimesExecuted();
                Assert.assertEquals((int)0, (int)sleepActionExec.getTimesExecuted());
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                System.out.println("Job " + ((ScheduledPersistedActionImpl)schedule).getPersistedAtNodeRef() + " starts now, repeats twice @ 2s");
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Thread.sleep(4250L);
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                if (sleepActionExec.getTimesExecuted() == 3) {
                    Assert.assertEquals((int)3, (int)sleepActionExec.getTimesExecuted());
                } else {
                    Assert.assertEquals((int)2, (int)sleepActionExec.getTimesExecuted());
                }
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                Assert.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobNames("PersistedActions").length);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                schedule.setScheduleStart(new Date(System.currentTimeMillis() + 2000L));
                schedule.setScheduleIntervalCount(1);
                schedule.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                Assert.assertEquals((String)"1Second", (String)schedule.getScheduleInterval());
                sleepActionExec.resetTimesExecuted();
                Assert.assertEquals((int)0, (int)sleepActionExec.getTimesExecuted());
                System.out.println("Job starts in 2s, repeats @ 1s");
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(schedule);
                return null;
            }
        }, false, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Thread.sleep(5000L);
                ScheduledPersistedAction schedule = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                Assert.assertEquals((int)1, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobNames("PersistedActions").length);
                ScheduledPersistedActionServiceTest.this.service.deleteSchedule(schedule);
                Assert.assertEquals((int)0, (int)ScheduledPersistedActionServiceTest.this.scheduler.getJobNames("PersistedActions").length);
                Assert.assertEquals((String)("Didn't run enough - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() >= 3 ? 1 : 0) != 0);
                Assert.assertEquals((String)("Ran too much - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() < 5 ? 1 : 0) != 0);
                Thread.sleep(500L);
                return null;
            }
        }, false, true);
    }

    public void testMultipleExecutions() throws Exception {
        final ActionServiceImplTest.SleepActionExecuter sleepActionExec = (ActionServiceImplTest.SleepActionExecuter)ctx.getBean("sleep-action");
        sleepActionExec.resetTimesExecuted();
        sleepActionExec.setSleepMs(1);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedActionImpl scheduleA = (ScheduledPersistedActionImpl)ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                scheduleA.setScheduleStart(new Date(System.currentTimeMillis() + 2000L));
                scheduleA.setScheduleEnd(new Date(System.currentTimeMillis() + 9000L));
                scheduleA.setScheduleIntervalCount(2);
                scheduleA.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(scheduleA);
                ScheduledPersistedActionImpl scheduleB = (ScheduledPersistedActionImpl)ScheduledPersistedActionServiceTest.this.service.createSchedule(ScheduledPersistedActionServiceTest.this.testAction2);
                scheduleB.setScheduleStart(new Date(System.currentTimeMillis()));
                scheduleB.setScheduleEnd(new Date(System.currentTimeMillis() + 9500L));
                scheduleB.setScheduleIntervalCount(1);
                scheduleB.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.Second);
                ScheduledPersistedActionServiceTest.this.service.saveSchedule(scheduleB);
                return null;
            }
        }, false, true);
        this.scheduler.start();
        Thread.sleep(10000L);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ScheduledPersistedAction scheduleA = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction);
                ScheduledPersistedAction scheduleB = ScheduledPersistedActionServiceTest.this.service.getSchedule(ScheduledPersistedActionServiceTest.this.testAction2);
                Assert.assertEquals((double)System.currentTimeMillis(), (double)scheduleA.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                Assert.assertEquals((double)System.currentTimeMillis(), (double)scheduleB.getScheduleLastExecutedAt().getTime(), (double)2500.0);
                Assert.assertEquals((String)("Didn't run enough - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() >= 11 ? 1 : 0) != 0);
                Assert.assertEquals((String)("Ran too much - " + sleepActionExec.getTimesExecuted()), (boolean)true, (sleepActionExec.getTimesExecuted() < 16 ? 1 : 0) != 0);
                return null;
            }
        }, false, true);
    }

    protected static class TestAction
    extends ActionImpl {
        protected TestAction(Action action) {
            super(action);
        }
    }

    public static class TestJob
    implements Job,
    ApplicationContextAware {
        private static boolean gotContext = false;
        private static boolean ran = false;

        public TestJob() {
            gotContext = false;
            ran = false;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            gotContext = true;
        }

        public void execute(JobExecutionContext paramJobExecutionContext) throws JobExecutionException {
            ran = true;
        }
    }
}

