/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.domain.activities.FeedControlDAO;
import org.alfresco.repo.domain.activities.FeedControlEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.activities.ActivityPostService;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.activities.FeedControl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityServiceImpl
implements ActivityService {
    private static final Log logger = LogFactory.getLog(ActivityServiceImpl.class);
    private ActivityFeedDAO feedDAO;
    private FeedControlDAO feedControlDAO;
    private AuthorityService authorityService;
    private TenantService tenantService;
    private SiteService siteService;
    private ActivityPostService activityPostService;
    private int maxFeedItems = 100;
    private boolean userNamesAreCaseSensitive = false;

    public void setMaxFeedItems(int maxFeedItems) {
        this.maxFeedItems = maxFeedItems;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setFeedControlDAO(FeedControlDAO feedControlDAO) {
        this.feedControlDAO = feedControlDAO;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityPostService(ActivityPostService activityPostService) {
        this.activityPostService = activityPostService;
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, String activityData) {
        this.activityPostService.postActivity(activityType, siteId, appTool, activityData);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef, name);
    }

    @Override
    public void postActivity(String activityType, String siteId, String appTool, NodeRef nodeRef, String name, QName typeQName, NodeRef parentNodeRef) {
        this.activityPostService.postActivity(activityType, siteId, appTool, nodeRef, name, typeQName, parentNodeRef);
    }

    @Override
    public List<String> getUserFeedEntries(String feedUserId, String format, String siteId) {
        return this.getUserFeedEntries(feedUserId, format, siteId, false, false);
    }

    @Override
    public List<String> getUserFeedEntries(String feedUserId, String format, String siteId, boolean excludeThisUser, boolean excludeOtherUsers) {
        String currentUser;
        ParameterCheck.mandatoryString((String)"feedUserId", (String)feedUserId);
        ParameterCheck.mandatoryString((String)"format", (String)format);
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        if (!this.userNamesAreCaseSensitive) {
            feedUserId = feedUserId.toLowerCase();
        }
        if (!((currentUser = this.getCurrentUser()) == null || currentUser.equals(AuthenticationUtil.getSystemUserName()) || this.authorityService.isAdminAuthority(currentUser) || currentUser.equals(feedUserId))) {
            throw new AccessDeniedException("Unable to get user feed entries for '" + feedUserId + "' - currently logged in as '" + currentUser + "'");
        }
        try {
            List<ActivityFeedEntity> activityFeeds = null;
            if (siteId != null) {
                siteId = this.tenantService.getName(siteId);
            }
            activityFeeds = this.feedDAO.selectUserFeedEntries(feedUserId, format, siteId, excludeThisUser, excludeOtherUsers);
            int count = 0;
            for (ActivityFeedEntity activityFeed : activityFeeds) {
                if (++count <= this.maxFeedItems) {
                    activityFeed.setSiteNetwork(this.tenantService.getBaseName(activityFeed.getSiteNetwork()));
                    activityFeedEntries.add(activityFeed.getJSONString());
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get user feed entries: " + se.getMessage());
            logger.error((Object)are);
            throw are;
        }
        catch (JSONException je) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get user feed entries: " + je.getMessage());
            logger.error((Object)are);
            throw are;
        }
        return activityFeedEntries;
    }

    @Override
    public List<String> getSiteFeedEntries(String siteId, String format) {
        ParameterCheck.mandatoryString((String)"siteId", (String)siteId);
        ParameterCheck.mandatoryString((String)"format", (String)format);
        ArrayList<String> activityFeedEntries = new ArrayList<String>();
        try {
            SiteInfo siteInfo;
            if (this.siteService != null && (siteInfo = this.siteService.getSite(siteId)) == null) {
                throw new AccessDeniedException("No such site: " + siteId);
            }
            siteId = this.tenantService.getName(siteId);
            List<ActivityFeedEntity> activityFeeds = this.feedDAO.selectSiteFeedEntries(siteId, format);
            int count = 0;
            for (ActivityFeedEntity activityFeed : activityFeeds) {
                if (++count <= this.maxFeedItems) {
                    activityFeed.setSiteNetwork(this.tenantService.getBaseName(activityFeed.getSiteNetwork()));
                    activityFeedEntries.add(activityFeed.getJSONString());
                    continue;
                }
                break;
            }
        }
        catch (SQLException se) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get site feed entries: " + se.getMessage());
            logger.error((Object)are);
            throw are;
        }
        catch (JSONException je) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Unable to get site feed entries: " + je.getMessage());
            logger.error((Object)are);
            throw are;
        }
        return activityFeedEntries;
    }

    @Override
    public void setFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        if (userId == null) {
            throw new AlfrescoRuntimeException("Current user " + userId + " is not permitted to set feed control");
        }
        try {
            if (!this.existsFeedControl(feedControl)) {
                this.feedControlDAO.insertFeedControl(new FeedControlEntity(userId, feedControl));
            }
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to set feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public List<FeedControl> getFeedControls() {
        String userId = this.getCurrentUser();
        return this.getFeedControlsImpl(userId);
    }

    @Override
    public List<FeedControl> getFeedControls(String userId) {
        String currentUser;
        ParameterCheck.mandatoryString((String)"userId", (String)userId);
        if (!this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        if ((currentUser = this.getCurrentUser()) == null || !currentUser.equals(AuthenticationUtil.getSystemUserName()) && !currentUser.equals(userId) && !this.authorityService.isAdminAuthority(currentUser)) {
            throw new AlfrescoRuntimeException("Current user " + currentUser + " is not permitted to get feed controls for " + userId);
        }
        return this.getFeedControlsImpl(userId);
    }

    private List<FeedControl> getFeedControlsImpl(String userId) {
        ParameterCheck.mandatoryString((String)"userId", (String)userId);
        try {
            List<FeedControlEntity> feedControlDaos = this.feedControlDAO.selectFeedControls(userId);
            ArrayList<FeedControl> feedControls = new ArrayList<FeedControl>(feedControlDaos.size());
            for (FeedControlEntity feedControlDao : feedControlDaos) {
                feedControls.add(feedControlDao.getFeedControl());
            }
            return feedControls;
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to get feed controls: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public void unsetFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        if (userId == null) {
            throw new AlfrescoRuntimeException("Current user " + userId + " is not permitted to unset feed control");
        }
        try {
            this.feedControlDAO.deleteFeedControl(new FeedControlEntity(userId, feedControl));
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to unset feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    @Override
    public boolean existsFeedControl(FeedControl feedControl) {
        ParameterCheck.mandatory((String)"feedControl", (Object)feedControl);
        String userId = this.getCurrentUser();
        try {
            long id = this.feedControlDAO.selectFeedControl(new FeedControlEntity(userId, feedControl));
            return id != -1L;
        }
        catch (SQLException e) {
            AlfrescoRuntimeException are = new AlfrescoRuntimeException("Failed to query feed control: " + e, (Throwable)e);
            logger.error((Object)are);
            throw are;
        }
    }

    private String getCurrentUser() {
        String userId = AuthenticationUtil.getFullyAuthenticatedUser();
        if (userId != null && !userId.equals("System") && !this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        return userId;
    }

    private FeedControl getTenantFeedControl(FeedControl feedControl) {
        return null;
    }

    private FeedControl getBaseFeedControl(FeedControl feedControl) {
        return null;
    }
}

