/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import org.alfresco.repo.activities.ActivityPostServiceImpl;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public abstract class AbstractFeedGenerator
implements FeedGenerator {
    private static Log logger = LogFactory.getLog(AbstractFeedGenerator.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(AbstractFeedGenerator.class.getName());
    private int maxItemsPerCycle = 100;
    private ActivityPostDAO postDAO;
    private ActivityPostServiceImpl activityPostServiceImpl;
    private AuthenticationService authenticationService;
    private String repoEndPoint;
    private boolean userNamesAreCaseSensitive = false;
    private RepoCtx ctx = null;
    private volatile boolean busy;

    public void setActivityPostServiceImpl(ActivityPostServiceImpl activityPostServiceImpl) {
        this.activityPostServiceImpl = activityPostServiceImpl;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setRepoEndPoint(String repoEndPoint) {
        this.repoEndPoint = repoEndPoint;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setMaxItemsPerCycle(int maxItemsPerCycle) {
        this.maxItemsPerCycle = maxItemsPerCycle;
    }

    public int getMaxItemsPerCycle() {
        return this.maxItemsPerCycle;
    }

    public ActivityPostDAO getPostDaoService() {
        return this.postDAO;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public RepoCtx getWebScriptsCtx() {
        return this.ctx;
    }

    public void init() throws Exception {
        this.ctx = new RepoCtx(this.repoEndPoint);
        this.ctx.setUserNamesAreCaseSensitive(this.userNamesAreCaseSensitive);
        this.busy = false;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        this.activityPostServiceImpl.setEstimatedGridSize(this.getEstimatedGridSize());
    }

    public abstract int getEstimatedGridSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws JobExecutionException {
        if (this.busy) {
            logger.warn((Object)"Still busy ...");
            return;
        }
        this.busy = true;
        try {
            this.checkProperties();
            this.generate();
        }
        catch (Throwable e) {
            if (vmShutdownListener.isVmShuttingDown()) {
            } else {
                logger.error((Object)"Exception during generation of feeds", e);
            }
        }
        finally {
            this.busy = false;
        }
    }

    protected abstract boolean generate() throws Exception;
}

