/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public abstract class BaseInterpreter
extends AbstractLifecycleBean {
    protected TransactionService transactionService;
    protected AuthorityService authorityService;
    private BufferedReader fIn = new BufferedReader(new InputStreamReader(System.in));
    private String username = null;
    protected String lastCommand = null;

    public static void runMain(String beanName) {
        ApplicationContext context = ApplicationContextHelper.getApplicationContext();
        BaseInterpreter.runMain(context, beanName);
    }

    public static void runMain(ApplicationContext context, String beanName) {
        BaseInterpreter console = BaseInterpreter.getConsoleBean(context, beanName);
        console.username = AuthenticationUtil.getAdminUserName();
        console.rep();
        System.exit(0);
    }

    public static BaseInterpreter getConsoleBean(ApplicationContext context, String beanName) {
        return (BaseInterpreter)((Object)context.getBean(beanName));
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void rep() {
        while (true) {
            System.out.print("ok> ");
            try {
                String line = this.fIn.readLine();
                if (line.equals("exit") || line.equals("quit")) {
                    return;
                }
                long startms = System.currentTimeMillis();
                System.out.print(this.interpretCommand(line));
                System.out.println("" + (System.currentTimeMillis() - startms) + "ms");
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                System.out.println("");
                continue;
            }
            break;
        }
    }

    public String interpretCommand(final String line) throws IOException {
        String currentUserName = this.getCurrentUserName();
        if (this.hasAuthority(currentUserName)) {
            return (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

                public String doWork() throws Exception {
                    RetryingTransactionHelper.RetryingTransactionCallback<String> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                        @Override
                        public String execute() throws Exception {
                            return BaseInterpreter.this.executeCommand(line);
                        }
                    };
                    return BaseInterpreter.this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork);
                }
            }, (String)currentUserName);
        }
        return "Error: User '" + currentUserName + "' not authorised";
    }

    protected boolean hasAuthority(String username) {
        if (this.authorityService == null) {
            this.authorityService = (AuthorityService)this.getApplicationContext().getBean("AuthorityService");
        }
        return username != null && this.authorityService.isAdminAuthority(username);
    }

    protected abstract String executeCommand(String var1) throws IOException;

    public String getCurrentUserName() {
        if (this.username == null) {
            return AuthenticationUtil.getFullyAuthenticatedUser();
        }
        return this.username;
    }

    public void setCurrentUserName(String username) {
        this.username = username;
    }

    protected void onBootstrap(ApplicationEvent event) {
    }

    protected void onShutdown(ApplicationEvent event) {
    }
}

