/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchServiceImpl
implements PatchService {
    private static final String MSG_NOT_RELEVANT = "patch.service.not_relevant";
    private static final String MSG_PRECEEDED_BY_ALTERNATIVE = "patch.service.preceeded_by_alternative";
    private static final String MSG_APPLYING_PATCH = "patch.service.applying_patch";
    private static final String MSG_VALIDATION_FAILED = "patch.validation.failed";
    private static final Date ZERO_DATE = new Date(0L);
    private static final Date INFINITE_DATE = new Date(Long.MAX_VALUE);
    private static Log logger = LogFactory.getLog(PatchExecuter.class);
    private DescriptorService descriptorService;
    private TransactionServiceImpl transactionService;
    private RuleService ruleService;
    private AppliedPatchDAO appliedPatchDAO;
    private List<Patch> patches = new ArrayList<Patch>(10);

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setAppliedPatchDAO(AppliedPatchDAO appliedPatchDAO) {
        this.appliedPatchDAO = appliedPatchDAO;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    public void registerPatch(Patch patch) {
        this.patches.add(patch);
    }

    @Override
    public boolean validatePatches() {
        boolean success = true;
        int serverSchemaVersion = this.descriptorService.getServerDescriptor().getSchema();
        for (Patch patch : this.patches) {
            if (patch.getFixesToSchema() <= serverSchemaVersion) continue;
            logger.error((Object)I18NUtil.getMessage((String)MSG_VALIDATION_FAILED, (Object[])new Object[]{patch.getId(), serverSchemaVersion, patch.getFixesToSchema(), patch.getTargetSchema()}));
            success = false;
        }
        if (!success) {
            this.transactionService.setAllowWrite(false);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyOutstandingPatches() {
        boolean success = true;
        try {
            this.ruleService.disableRules();
            try {
                ArrayList<Patch> sortedPatches = new ArrayList<Patch>(this.patches);
                PatchTargetSchemaComparator comparator = new PatchTargetSchemaComparator();
                Collections.sort(sortedPatches, comparator);
                HashMap<String, AppliedPatch> appliedPatchesById = new HashMap<String, AppliedPatch>(23);
                List<AppliedPatch> appliedPatches = this.appliedPatchDAO.getAppliedPatches();
                for (final AppliedPatch appliedPatch : appliedPatches) {
                    appliedPatchesById.put(appliedPatch.getId(), appliedPatch);
                    if (appliedPatch.getAppliedOnDate() != null) continue;
                    RetryingTransactionHelper.RetryingTransactionCallback<Date> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Date>(){

                        @Override
                        public Date execute() throws Throwable {
                            Date now = new Date();
                            appliedPatch.setAppliedOnDate(now);
                            PatchServiceImpl.this.appliedPatchDAO.updateAppliedPatch(appliedPatch);
                            return now;
                        }
                    };
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
                }
                for (Patch patch : sortedPatches) {
                    success = this.applyPatchAndDependencies(patch, appliedPatchesById);
                    if (success) continue;
                    break;
                }
            }
            finally {
                this.ruleService.enableRules();
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        return success;
    }

    private boolean applyPatchAndDependencies(final Patch patch, Map<String, AppliedPatch> appliedPatchesById) {
        String id = patch.getId();
        AppliedPatch appliedPatch = appliedPatchesById.get(id);
        if (appliedPatch != null && appliedPatch.getSucceeded() && appliedPatch.getWasExecuted() && appliedPatch.getSucceeded()) {
            return true;
        }
        List<Patch> dependencies = patch.getDependsOn();
        for (Patch dependencyPatch : dependencies) {
            boolean success = this.applyPatchAndDependencies(dependencyPatch, appliedPatchesById);
            if (success) continue;
            return false;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<AppliedPatch> callback = new RetryingTransactionHelper.RetryingTransactionCallback<AppliedPatch>(){

            @Override
            public AppliedPatch execute() throws Throwable {
                return PatchServiceImpl.this.applyPatch(patch);
            }
        };
        appliedPatch = this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        if (!appliedPatch.getSucceeded()) {
            return false;
        }
        appliedPatchesById.put(id, appliedPatch);
        return true;
    }

    private AppliedPatch applyPatch(Patch patch) {
        boolean applies;
        AppliedPatch appliedPatch;
        boolean forcePatch = patch.isForce();
        if (forcePatch) {
            logger.warn((Object)("Patch will be forcefully executed: \n   Patch: " + patch));
        }
        if ((appliedPatch = this.appliedPatchDAO.getAppliedPatch(patch.getId())) != null && !forcePatch && appliedPatch.getSucceeded()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Patch was already successfully applied: \n   Patch: " + appliedPatch));
            }
            return appliedPatch;
        }
        String report = null;
        boolean success = false;
        Descriptor repoDescriptor = this.descriptorService.getInstalledRepositoryDescriptor();
        String preceededByAlternative = forcePatch ? null : this.preceededByAlternative(patch);
        boolean bl = applies = forcePatch || this.applies(repoDescriptor, patch);
        if (!applies) {
            report = I18NUtil.getMessage((String)MSG_NOT_RELEVANT, (Object[])new Object[]{repoDescriptor.getSchema()});
            success = true;
        } else if (preceededByAlternative != null) {
            report = I18NUtil.getMessage((String)MSG_PRECEEDED_BY_ALTERNATIVE, (Object[])new Object[]{preceededByAlternative});
            success = true;
        } else {
            try {
                String msg = I18NUtil.getMessage((String)MSG_APPLYING_PATCH, (Object[])new Object[]{patch.getId(), I18NUtil.getMessage((String)patch.getDescription())});
                logger.info((Object)msg);
                report = patch.apply();
                success = true;
            }
            catch (PatchException e) {
                report = e.getMessage();
                success = false;
                logger.error((Object)report);
            }
        }
        Descriptor serverDescriptor = this.descriptorService.getServerDescriptor();
        String server = serverDescriptor.getVersion() + " - " + serverDescriptor.getEdition();
        boolean create = true;
        if (appliedPatch == null) {
            appliedPatch = new AppliedPatch();
            appliedPatch.setId(patch.getId());
            create = true;
        } else {
            create = false;
        }
        String patchDescription = I18NUtil.getMessage((String)patch.getDescription());
        if (patchDescription == null) {
            logger.warn((Object)("Patch description is not available: " + patch));
            patchDescription = "No patch description available";
        }
        appliedPatch.setDescription(patchDescription);
        appliedPatch.setFixesFromSchema(patch.getFixesFromSchema());
        appliedPatch.setFixesToSchema(patch.getFixesToSchema());
        appliedPatch.setTargetSchema(patch.getTargetSchema());
        appliedPatch.setAppliedToSchema(repoDescriptor.getSchema());
        appliedPatch.setAppliedToServer(server);
        appliedPatch.setAppliedOnDate(new Date());
        appliedPatch.setSucceeded(success);
        appliedPatch.setWasExecuted(applies);
        appliedPatch.setReport(report);
        if (create) {
            this.appliedPatchDAO.createAppliedPatch(appliedPatch);
        } else {
            this.appliedPatchDAO.updateAppliedPatch(appliedPatch);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applied patch: \n" + appliedPatch));
        }
        return appliedPatch;
    }

    private String preceededByAlternative(Patch patch) {
        List<Patch> alternatives = patch.getAlternatives();
        for (Patch alternative : alternatives) {
            AppliedPatch appliedAlternative = this.appliedPatchDAO.getAppliedPatch(alternative.getId());
            if (appliedAlternative == null || !appliedAlternative.getSucceeded()) continue;
            return alternative.getId();
        }
        return null;
    }

    private boolean applies(Descriptor repoDescriptor, Patch patch) {
        int repoSchema = repoDescriptor.getSchema();
        boolean apply = patch.applies(repoSchema);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Patch schema version number check against repo version: \n   repo schema version: " + repoDescriptor.getVersion() + "\n" + "   patch: " + patch));
        }
        return apply;
    }

    @Override
    public List<AppliedPatch> getPatches(Date fromDate, Date toDate) {
        if (fromDate == null) {
            fromDate = ZERO_DATE;
        }
        if (toDate == null) {
            toDate = INFINITE_DATE;
        }
        List<AppliedPatch> appliedPatches = this.appliedPatchDAO.getAppliedPatches(fromDate, toDate);
        return appliedPatches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatchTargetSchemaComparator
    implements Comparator<Patch> {
        private PatchTargetSchemaComparator() {
        }

        @Override
        public int compare(Patch p1, Patch p2) {
            Integer i1 = new Integer(p1.getTargetSchema());
            Integer i2 = new Integer(p2.getTargetSchema());
            return i1.compareTo(i2);
        }
    }
}

