/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.impl.DuplicateEntry;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class EliminateDuplicatesPatch
extends AbstractPatch {
    private Log LOGGER = LogFactory.getLog(EliminateDuplicatesPatch.class);
    private static final String RENAMED_MARK_KEY = "renamed.duplicate.mark";
    private static final char EXTENSION_DELIMITER = '.';
    private static final char TOKENS_DELIMITER = '-';
    private String renamedMark;
    private String temporaryExtension;
    private AvmDuplicatesIBatisDao helper = new AvmDuplicatesIBatisDao();

    public String getRenamedMark() {
        if (null == this.renamedMark) {
            String mark = I18NUtil.getMessage((String)RENAMED_MARK_KEY);
            StringBuilder markBuilder = new StringBuilder().append('-');
            this.renamedMark = markBuilder.append(mark).append('-').toString();
        }
        return this.renamedMark;
    }

    public void setTemporaryExtension(String temporaryExtension) {
        this.temporaryExtension = temporaryExtension;
    }

    public void setTemplate(SqlMapClientTemplate template) {
        this.helper.setTemplate(template);
    }

    protected String applyInternal() throws Exception {
        int totalRenamed = 0;
        int duplicateGroupsAmount = 0;
        List<DuplicateEntry> duplicates = this.helper.getDuplicates();
        Iterator<DuplicateEntry> duplicatesIterator = duplicates.iterator();
        DuplicateEntry duplicate = null;
        while (duplicatesIterator.hasNext() && null != (duplicate = duplicatesIterator.next())) {
            ++duplicateGroupsAmount;
            int renamed = 0;
            int processed = 1;
            long amount = duplicate.getAmount();
            while (duplicatesIterator.hasNext() && amount > (long)processed) {
                duplicate = duplicatesIterator.next();
                ++processed;
                String newName = this.generatePatchedName(duplicate);
                boolean renamingResult = this.helper.renameNode(new DuplicateEntry(duplicate.getId(), duplicate.getParentId(), newName, 1L));
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug((Object)("Trying to rename Node with id = '" + duplicate.getId() + "' and parent id = '" + duplicate.getParentId() + "' from '" + duplicate.getName() + "' to '" + newName + "'. Result: " + renamingResult));
                }
                if (!renamingResult) continue;
                ++renamed;
                ++totalRenamed;
            }
            if (!this.LOGGER.isDebugEnabled()) continue;
            this.LOGGER.debug((Object)("Duplicates for '" + duplicate.getName().toLowerCase() + "' name and parentId='" + duplicate.getParentId() + "': " + duplicate.getAmount() + ". Renamed: " + renamed));
        }
        StringBuilder result = new StringBuilder();
        result.append(duplicateGroupsAmount).append(" duplicate group(s) were found\n");
        result.append(duplicates.size()).append(" affected node entries\n");
        result.append("----------------\nTotal renamed: ").append(totalRenamed).append('\n');
        return result.toString();
    }

    private String generatePatchedName(DuplicateEntry node) {
        StringBuilder result = new StringBuilder();
        StringBuilder extension = new StringBuilder();
        AVMNode avmNode = AVMDAOs.Instance().fAVMNodeDAO.getByID(node.getId());
        String oldName = node.getName();
        if (1 == avmNode.getType() || 0 == avmNode.getType()) {
            int dotPosition = oldName.indexOf(46);
            if (-1 != dotPosition) {
                extension.append(oldName.substring(dotPosition));
                oldName = oldName.substring(0, dotPosition);
            }
            if (null != this.temporaryExtension && this.temporaryExtension.length() > 0) {
                extension.append('.').append(this.temporaryExtension);
            }
        }
        result.append(oldName).append(this.getRenamedMark()).append(GUID.generate()).append(extension.toString());
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AvmDuplicatesIBatisDao {
        private static final String QUERY_SELECT_DUPLICATES_ID = "alfresco.patch.select_AvmNodeDuplicates";
        private static final String QUERY_RENAME_NODE_ID = "alfresco.patch.update_AvmNodeNameById";
        private SqlMapClientTemplate template;

        private AvmDuplicatesIBatisDao() {
        }

        public void setTemplate(SqlMapClientTemplate template) {
            this.template = template;
        }

        public List<DuplicateEntry> getDuplicates() {
            return this.template.queryForList(QUERY_SELECT_DUPLICATES_ID);
        }

        public boolean renameNode(DuplicateEntry renamedEntry) {
            return this.template.update(QUERY_RENAME_NODE_ID, (Object)renamedEntry) > 0;
        }
    }
}

