/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;

class AVMCrawler
implements Runnable {
    private static Log logger = LogFactory.getLog(AVMCrawler.class);
    private AVMService fService;
    private Authentication authentication;
    private int fOpCount;
    private boolean fDone;
    private boolean fError;
    private String fErrorStackTrace = null;
    private Random fRandom;

    public AVMCrawler(AVMService service, Authentication authentication) {
        this.fService = service;
        this.authentication = authentication;
        this.fOpCount = 0;
        this.fDone = false;
        this.fError = false;
        this.fRandom = new Random();
    }

    public void setDone() {
        this.fDone = true;
    }

    public boolean getError() {
        return this.fError;
    }

    public String getErrorStackTrace() {
        return this.fErrorStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                AuthenticationUtil.setFullAuthentication((Authentication)this.authentication);
                while (!this.fDone) {
                    this.doCrawl();
                }
                Object var5_1 = null;
            }
            catch (Throwable t) {
                t.printStackTrace();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                this.fError = true;
                this.fErrorStackTrace = sw.toString();
                Object var5_2 = null;
                AuthenticationUtil.clearCurrentSecurityContext();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            AuthenticationUtil.clearCurrentSecurityContext();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void doCrawl() {
        try {
            List<AVMStoreDescriptor> reps = this.fService.getStores();
            ++this.fOpCount;
            if (reps.size() == 0) {
                logger.warn((Object)"No AVM stores");
                return;
            }
            AVMStoreDescriptor repDesc = reps.get(this.fRandom.nextInt(reps.size()));
            SortedMap<String, AVMNodeDescriptor> rootListing = this.fService.getDirectoryListing(-1, repDesc.getName() + ":/");
            ++this.fOpCount;
            ArrayList<AVMNodeDescriptor> dirs = new ArrayList<AVMNodeDescriptor>();
            for (AVMNodeDescriptor desc : rootListing.values()) {
                if (!desc.isDirectory()) continue;
                dirs.add(desc);
            }
            if (dirs.size() == 0) {
                logger.warn((Object)("No dirs in root: " + repDesc.getName() + ":/"));
            } else {
                AVMNodeDescriptor dir = (AVMNodeDescriptor)dirs.get(this.fRandom.nextInt(dirs.size()));
                int depth = 1;
                while (dir != null) {
                    String name;
                    SortedMap<String, AVMNodeDescriptor> listing = this.fService.getDirectoryListing(-1, dir.getPath());
                    ++this.fOpCount;
                    ArrayList<AVMNodeDescriptor> files = new ArrayList<AVMNodeDescriptor>();
                    dirs = new ArrayList();
                    for (AVMNodeDescriptor desc : listing.values()) {
                        if (desc.isDirectory()) {
                            dirs.add(desc);
                            continue;
                        }
                        files.add(desc);
                    }
                    if (files.size() > 0) {
                        String path;
                        int i;
                        for (i = 0; i < 6; ++i) {
                            path = ((AVMNodeDescriptor)files.get(this.fRandom.nextInt(files.size()))).getPath();
                            logger.info((Object)("Reading: " + path));
                            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fService.getFileInputStream(-1, path)));
                            ++this.fOpCount;
                            String line = reader.readLine();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)line);
                            }
                            reader.close();
                        }
                        for (i = 0; i < 2; ++i) {
                            path = ((AVMNodeDescriptor)files.get(this.fRandom.nextInt(files.size()))).getPath();
                            logger.info((Object)("Modifying: " + path));
                            PrintStream out = new PrintStream(this.fService.getFileOutputStream(path));
                            out.println("I am " + path);
                            out.close();
                            ++this.fOpCount;
                        }
                    }
                    if (this.fRandom.nextInt(depth) < depth - 1) {
                        for (int i = 0; i < 1 && !listing.containsKey(name = this.randomName()); ++i) {
                            logger.info((Object)("Creating File: " + name));
                            this.fService.createFile(dir.getPath(), name, new ByteArrayInputStream(("I am " + name).getBytes()));
                            ++this.fOpCount;
                        }
                    }
                    if (this.fRandom.nextInt(100) == 0) {
                        String name2 = this.randomName();
                        if (listing.containsKey(name2)) break;
                        logger.info((Object)("Creating Directory: " + name2));
                        this.fService.createDirectory(dir.getPath(), name2);
                        ++this.fOpCount;
                    }
                    if (listing.size() > 0 && this.fRandom.nextInt(100) == 0) {
                        ArrayList names = new ArrayList(listing.keySet());
                        name = (String)names.get(this.fRandom.nextInt(names.size()));
                        logger.info((Object)("Removing: " + name));
                        this.fService.removeNode(dir.getPath(), name);
                        ++this.fOpCount;
                    }
                    dir = dirs.size() > 0 ? (AVMNodeDescriptor)dirs.get(this.fRandom.nextInt(dirs.size())) : null;
                    ++depth;
                }
            }
            if (this.fRandom.nextInt(16) == 0) {
                logger.info((Object)("Snapshotting: " + repDesc.getName()));
                this.fService.createSnapshot(repDesc.getName(), null, null);
                ++this.fOpCount;
            }
        }
        catch (Exception e) {
            if (e instanceof AVMNotFoundException || e instanceof AVMException || e instanceof ContentIOException || e instanceof ConcurrencyFailureException) {
                logger.warn((Object)e.getMessage());
                return;
            }
            e.printStackTrace(System.err);
            throw new AVMException("Failure", e);
        }
    }

    private String randomName() {
        char[] chars = new char[]{(char)(97 + this.fRandom.nextInt(12)), (char)(97 + this.fRandom.nextInt(12))};
        return new String(chars);
    }

    public int getOpCount() {
        return this.fOpCount;
    }
}

