/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.CreateStoreCallback;
import org.alfresco.repo.transaction.TransactionListenerAdapter;

public class CreateStoreTxnListener
extends TransactionListenerAdapter {
    private ThreadLocal<List<String>> fCreatedStores = new ThreadLocal();
    private List<CreateStoreCallback> fCallbacks = new ArrayList<CreateStoreCallback>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit() {
        List<String> created = this.fCreatedStores.get();
        if (created != null) {
            for (String name : created) {
                CreateStoreTxnListener createStoreTxnListener = this;
                synchronized (createStoreTxnListener) {
                    for (CreateStoreCallback cb : this.fCallbacks) {
                        cb.storeCreated(name);
                    }
                }
            }
            this.fCreatedStores.set(null);
        }
    }

    public void afterRollback() {
        this.fCreatedStores.set(null);
    }

    public void storeCreated(String storeName) {
        List<String> created = this.fCreatedStores.get();
        if (created == null) {
            created = new ArrayList<String>();
            this.fCreatedStores.set(created);
        }
        created.add(storeName);
    }

    public synchronized void addCallback(CreateStoreCallback cb) {
        this.fCallbacks.add(cb);
    }
}

