/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import org.alfresco.repo.avm.util.SimplePath;

public class LookupKey
implements Serializable {
    private static final long serialVersionUID = 8471482833953423406L;
    private String fStoreName;
    private SimplePath fPath;
    private int fVersion;
    private boolean fWrite;
    private boolean fIncludeDeleted;

    public LookupKey(int version, SimplePath path, String storeName, boolean write, boolean includeDeleted) {
        this.fVersion = version;
        this.fPath = path;
        this.fStoreName = storeName;
        this.fWrite = write;
        this.fIncludeDeleted = includeDeleted;
    }

    public LookupKey(LookupKey other) {
        this.fVersion = other.fVersion;
        this.fPath = other.fPath;
        this.fStoreName = other.fStoreName;
        this.fWrite = other.fWrite;
        this.fIncludeDeleted = other.fIncludeDeleted;
    }

    public void setWrite(boolean write) {
        this.fWrite = write;
    }

    public String getStoreName() {
        return this.fStoreName;
    }

    public boolean isWrite() {
        return this.fWrite;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LookupKey)) {
            return false;
        }
        LookupKey o = (LookupKey)obj;
        return this.fStoreName.equalsIgnoreCase(o.fStoreName) && this.fVersion == o.fVersion && this.fPath.equals(o.fPath) && this.fWrite == o.fWrite && this.fIncludeDeleted == o.fIncludeDeleted;
    }

    public int hashCode() {
        int hash = this.fStoreName.toLowerCase().hashCode();
        hash += this.fPath.hashCode();
        hash += this.fVersion;
        hash += this.fWrite ? 1 : 0;
        return hash += this.fIncludeDeleted ? 1 : 0;
    }

    public String toString() {
        return this.fStoreName + ":" + this.fPath + "-" + this.fVersion + "-" + this.fWrite + "-" + this.fIncludeDeleted;
    }
}

