/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeDAO;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMStoreDAO;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.LookupCache;
import org.alfresco.repo.avm.LookupKey;
import org.alfresco.repo.avm.VersionRoot;
import org.alfresco.repo.avm.util.SimplePath;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalLookupCache
implements LookupCache,
InitializingBean {
    private static Log fgLogger = LogFactory.getLog(TransactionalLookupCache.class);
    private static Log fgLoggerInit = LogFactory.getLog((String)(TransactionalLookupCache.class.getName() + ".init"));
    private SimpleCache<LookupKey, Lookup> fCache;
    private AVMNodeDAO fAVMNodeDAO;
    private AVMStoreDAO fAVMStoreDAO;

    public void setAvmNodeDAO(AVMNodeDAO dao) {
        this.fAVMNodeDAO = dao;
    }

    public void setAvmStoreDAO(AVMStoreDAO dao) {
        this.fAVMStoreDAO = dao;
    }

    public void setTransactionalCache(SimpleCache<LookupKey, Lookup> cache) {
        this.fCache = cache;
    }

    public void afterPropertiesSet() throws Exception {
        if (fgLoggerInit.isDebugEnabled()) {
            fgLoggerInit.debug((Object)"Transactional AVM lookup cache initialised");
        }
    }

    @Override
    public Lookup lookup(AVMStore store, int version, SimplePath path, boolean write, boolean includeDeleted) {
        LookupKey key = new LookupKey(version, path, store.getName(), write, includeDeleted);
        Lookup found = this.findInCache(key);
        if (found != null) {
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Cache Hit: " + key + ", " + found.getCurrentNode().getId()));
            }
            return found;
        }
        if (path.size() == 0) {
            return null;
        }
        Lookup result = new Lookup(store, store.getName(), version);
        DirectoryNode dir = null;
        if (version < 0) {
            dir = store.getRoot();
        } else {
            VersionRoot vRoot = AVMDAOs.Instance().fVersionRootDAO.getByVersionID(store, version);
            if (vRoot != null) {
                dir = vRoot.getRoot();
            }
        }
        if (dir == null) {
            return null;
        }
        result.add(dir, "", true, write);
        dir = (DirectoryNode)result.getCurrentNode();
        if (path.size() == 1 && path.get(0).equals("")) {
            this.fCache.put((Serializable)key, (Object)result);
            return result;
        }
        for (int i = 0; i < path.size() - 1; ++i) {
            if (!AVMRepository.GetInstance().can(null, dir, "ReadChildren", result.getDirectlyContained())) {
                throw new AccessDeniedException("Not allowed to read children: " + path.get(i));
            }
            Pair<AVMNode, Boolean> child = dir.lookupChild(result, path.get(i), includeDeleted);
            if (child == null) {
                return null;
            }
            if (((AVMNode)child.getFirst()).getType() != 2 && ((AVMNode)child.getFirst()).getType() != 3) {
                return null;
            }
            result.add((AVMNode)child.getFirst(), path.get(i), (Boolean)child.getSecond(), write);
            dir = (DirectoryNode)result.getCurrentNode();
        }
        if (!AVMRepository.GetInstance().can(null, dir, "ReadChildren", result.getDirectlyContained())) {
            throw new AccessDeniedException("Not allowed to read children: " + path.get(path.size() - 1));
        }
        Pair<AVMNode, Boolean> child = dir.lookupChild(result, path.get(path.size() - 1), includeDeleted);
        if (child == null) {
            return null;
        }
        result.add((AVMNode)child.getFirst(), path.get(path.size() - 1), (Boolean)child.getSecond(), write);
        this.fCache.put((Serializable)key, (Object)result);
        return result;
    }

    private synchronized Lookup findInCache(LookupKey key) {
        Lookup found = (Lookup)this.fCache.get((Serializable)key);
        if (found != null) {
            Lookup result = new Lookup(found, this.fAVMNodeDAO, this.fAVMStoreDAO);
            if (!result.isValid()) {
                fgLogger.error((Object)("Invalid entry in cache: " + key));
                return null;
            }
            return result;
        }
        if (!key.isWrite()) {
            LookupKey newKey = new LookupKey(key);
            newKey.setWrite(true);
            found = (Lookup)this.fCache.get((Serializable)newKey);
            if (found != null) {
                Lookup result = new Lookup(found, this.fAVMNodeDAO, this.fAVMStoreDAO);
                if (!result.isValid()) {
                    fgLogger.error((Object)("Invalid entry in cache: " + newKey));
                    return null;
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public synchronized void onWrite(String storeName) {
        ArrayList<LookupKey> keys = new ArrayList<LookupKey>();
        for (LookupKey key : this.fCache.getKeys()) {
            keys.add(key);
        }
        for (LookupKey key : keys) {
            Lookup value = (Lookup)this.fCache.get((Serializable)key);
            if ((!key.getStoreName().equals(storeName) || key.isWrite()) && value != null && (key.isWrite() || !value.isLayered())) continue;
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Invalidating: " + key + ", " + (value != null ? value.getCurrentNode().getId() : -2L)));
            }
            this.fCache.remove((Serializable)key);
        }
    }

    @Override
    public synchronized void onDelete(String storeName) {
        ArrayList<LookupKey> keys = new ArrayList<LookupKey>();
        for (LookupKey key : this.fCache.getKeys()) {
            keys.add(key);
        }
        for (LookupKey key : keys) {
            Lookup value = (Lookup)this.fCache.get((Serializable)key);
            if (!key.getStoreName().equals(storeName) && value != null && !value.isLayered()) continue;
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Invalidating: " + key + ", " + (value != null ? value.getCurrentNode().getId() : -2L)));
            }
            this.fCache.remove((Serializable)key);
        }
    }

    @Override
    public synchronized void onSnapshot(String storeName) {
        ArrayList<LookupKey> keys = new ArrayList<LookupKey>();
        for (LookupKey key : this.fCache.getKeys()) {
            keys.add(key);
        }
        for (LookupKey key : keys) {
            Lookup value = (Lookup)this.fCache.get((Serializable)key);
            if ((!key.getStoreName().equals(storeName) || !key.isWrite()) && value != null && !value.isLayered()) continue;
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("Invalidating: " + key + ", " + (value != null ? value.getCurrentNode().getId() : -2L)));
            }
            this.fCache.remove((Serializable)key);
        }
    }

    @Override
    public synchronized void reset() {
        this.fCache.clear();
    }
}

