/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.IOException;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PermissionService;

public class WCMInheritPermissionsTest
extends AVMServiceTestBase {
    private static final String FILE_NAME = "fileForExport";
    private static final String STORE_NAME = "TestStore1";
    private static final String ROOT = "ROOT";
    protected PermissionService permissionService;

    protected void setUp() throws Exception {
        super.setUp();
        this.permissionService = (PermissionService)fContext.getBean("permissionService");
    }

    private void createStagingWithSnapshots(String storeName) throws IOException {
        if (fService.getStore(storeName) != null) {
            fService.purgeStore(storeName);
        }
        fService.createStore(storeName);
        WCMInheritPermissionsTest.assertNotNull((Object)fService.getStore(storeName));
        fService.createDirectory(storeName + ":/", "www");
        fService.createSnapshot(storeName, "first", "first");
        WCMInheritPermissionsTest.assertNotNull((Object)fService.lookup(-1, storeName + ":/" + "www"));
        fService.createDirectory(storeName + ":/" + "www", "avm_webapps");
        fService.createSnapshot(storeName, "second", "second");
        WCMInheritPermissionsTest.assertNotNull((Object)fService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps"));
        fService.createDirectory(storeName + ":/" + "www" + "/" + "avm_webapps", ROOT);
        fService.createSnapshot(storeName, "third", "third");
        WCMInheritPermissionsTest.assertNotNull((Object)fService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT));
        fService.createFile(storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT, FILE_NAME).close();
        fService.createSnapshot(storeName, "fourth", "fourth");
        WCMInheritPermissionsTest.assertNotNull((Object)fService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT + "/" + FILE_NAME));
    }

    private void removeStore(String storeName) {
        fService.purgeStore(storeName);
        WCMInheritPermissionsTest.assertNull((Object)fService.getStore(storeName));
    }

    public void testSetInheritParentPermissions() throws IOException {
        this.createStagingWithSnapshots(STORE_NAME);
        AVMNodeDescriptor nodeDescriptor = fService.lookup(-1, "TestStore1:/www/avm_webapps/ROOT/fileForExport");
        WCMInheritPermissionsTest.assertNotNull((Object)nodeDescriptor);
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, nodeDescriptor.getPath());
        WCMInheritPermissionsTest.assertNotNull((Object)nodeRef);
        this.permissionService.setInheritParentPermissions(nodeRef, false);
        WCMInheritPermissionsTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(nodeRef));
        this.permissionService.setInheritParentPermissions(nodeRef, true);
        WCMInheritPermissionsTest.assertTrue((boolean)this.permissionService.getInheritParentPermissions(nodeRef));
        this.removeStore(STORE_NAME);
    }
}

