/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.actions;

import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMUndoSandboxListAction
extends ActionExecuterAbstractBase {
    private static Log fgLogger = LogFactory.getLog(AVMUndoSandboxListAction.class);
    public static final String NAME = "avm-undo-list";
    public static final String PARAM_NODE_LIST = "node-list";
    private AVMService fAVMService;
    private AVMLockingService fAVMLockingService;

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    public void setAvmLockingService(AVMLockingService service) {
        this.fAVMLockingService = service;
    }

    @Override
    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        List versionPaths = (List)((Object)action.getParameterValue(PARAM_NODE_LIST));
        for (Pair item : versionPaths) {
            String[] parentChild;
            String avmPath = (String)item.getSecond();
            AVMNodeDescriptor desc = this.fAVMService.lookup(-1, avmPath, true);
            if (desc == null || (parentChild = AVMNodeConverter.SplitBase(avmPath)).length != 2) continue;
            AVMNodeDescriptor parent = this.fAVMService.lookup(-1, parentChild[0], true);
            if (parent.isLayeredDirectory()) {
                if (fgLogger.isDebugEnabled()) {
                    fgLogger.debug((Object)("reverting " + parentChild[1] + " in " + parentChild[0]));
                }
                this.fAVMService.makeTransparent(parentChild[0], parentChild[1]);
            }
            if (!desc.isFile() && !desc.isDeletedFile()) continue;
            String[] parts = AVMUtil.splitPath(avmPath);
            String avmStore = parts[0];
            String path = parts[1];
            String webProject = WCMUtil.getWebProject(this.fAVMService, avmStore);
            if (webProject == null) continue;
            if (fgLogger.isDebugEnabled()) {
                fgLogger.debug((Object)("unlocking file " + path + " in web project " + webProject));
            }
            if (this.fAVMLockingService.getLockOwner(webProject, path) != null) {
                this.fAVMLockingService.removeLock(webProject, path);
                continue;
            }
            fgLogger.warn((Object)("expected file " + path + " in " + webProject + " to be locked"));
        }
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_NODE_LIST, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_NODE_LIST)));
    }
}

