/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.util;

import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMException;

public class AVMUtil {
    public static final char AVM_PATH_SEPARATOR_CHAR = '/';
    public static final String AVM_PATH_SEPARATOR = "/";
    public static final char AVM_STORE_SEPARATOR_CHAR = ':';
    public static final String AVM_STORE_SEPARATOR = ":";
    private static final String AVM_STORE_PATH_SEPARATOR = ":/";
    public static final String INITIAL_SNAPSHOT = "Initial Empty Version.";

    public static String getStoreName(String avmPath) {
        int i = avmPath.indexOf(58);
        if (i == -1) {
            throw new AVMBadArgumentException("path " + avmPath + " does not contain a store");
        }
        return avmPath.substring(0, i);
    }

    public static String[] splitPath(String path) {
        String[] pathParts = path.split(AVM_STORE_SEPARATOR);
        if (pathParts.length != 2) {
            throw new AVMBadArgumentException("Invalid path: " + path);
        }
        return pathParts;
    }

    public static String[] splitBase(String path) {
        path = path.replaceAll("/+", AVM_PATH_SEPARATOR);
        while (path.endsWith(AVM_PATH_SEPARATOR) && !path.endsWith(AVM_STORE_PATH_SEPARATOR)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(AVM_STORE_PATH_SEPARATOR)) {
            return new String[]{null, ""};
        }
        int off = path.lastIndexOf(AVM_PATH_SEPARATOR);
        if (off == -1) {
            throw new AVMException("Invalid Path: " + path);
        }
        String[] decomposed = new String[2];
        decomposed[0] = path.substring(0, off);
        if (decomposed[0].charAt(decomposed[0].length() - 1) == ':') {
            decomposed[0] = decomposed[0] + '/';
        }
        decomposed[1] = path.substring(off + 1);
        return decomposed;
    }

    public static String buildAVMPath(String storeName, String storeRelativePath) {
        StringBuilder builder = new StringBuilder();
        builder.append(storeName).append(':');
        if (storeRelativePath.length() == 0 || storeRelativePath.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(storeRelativePath);
        return builder.toString();
    }

    public static String extendAVMPath(String path, String name) {
        if (path.endsWith(AVM_PATH_SEPARATOR)) {
            return path + name;
        }
        return path + '/' + name;
    }

    public static String normalizePath(String path) {
        path = path.replaceAll("/+", AVM_PATH_SEPARATOR);
        path = path.replaceAll("/$", "");
        return path;
    }

    public static String addLeadingSlash(String relativePath) {
        if (relativePath.length() == 0 || relativePath.charAt(0) != '/') {
            relativePath = '/' + relativePath;
        }
        return relativePath;
    }
}

