/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.util;

import java.io.Serializable;

public class SimplePath
implements Serializable {
    private static final long serialVersionUID = 2696828491008988470L;
    private String[] fNames;

    public SimplePath(String path) {
        if (path.length() == 0) {
            this.fNames = new String[0];
            return;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.fNames = path.split("/+");
    }

    public String get(int index) {
        return this.fNames[index];
    }

    public int size() {
        return this.fNames.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePath)) {
            return false;
        }
        SimplePath o = (SimplePath)obj;
        if (this.fNames.length != o.fNames.length) {
            return false;
        }
        for (int i = 0; i < this.fNames.length; ++i) {
            if (this.fNames[i].equalsIgnoreCase(o.fNames[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (String name : this.fNames) {
            hash += name.toLowerCase().hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.fNames) {
            builder.append('/');
            builder.append(name);
        }
        return builder.toString();
    }
}

