/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.wf;

import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.alfresco.wcm.sandbox.SandboxFactory;
import org.alfresco.wcm.util.WCMUtil;
import org.jbpm.graph.exe.ExecutionContext;
import org.springframework.beans.factory.BeanFactory;

public class AVMRemoveWFStoreHandler
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 4113360751217684995L;
    private SandboxFactory sandboxFactory;

    protected void initialiseHandler(BeanFactory factory) {
        this.sandboxFactory = (SandboxFactory)factory.getBean("sandboxFactory");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        NodeRef pkg = ((JBPMNode)executionContext.getContextInstance().getVariable("bpm_package")).getNodeRef();
        Pair<Integer, String> pkgPath = AVMNodeConverter.ToAVMVersionPath(pkg);
        String workflowName = executionContext.getProcessDefinition().getName();
        final boolean isSubmitDirectWorkflowSandbox = workflowName != null && workflowName.equals("wcmwf:submitdirect");
        final String avmPath = (String)pkgPath.getSecond();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AVMRemoveWFStoreHandler.this.sandboxFactory.deleteSandbox(WCMUtil.getSandboxStoreId(avmPath), isSubmitDirectWorkflowSandbox);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }
}

