/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache.lookup;

import java.util.Map;
import java.util.TreeMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityLookupCacheTest
extends TestCase
implements EntityLookupCache.EntityLookupCallbackDAO<Long, Object, String> {
    SimpleCache<Long, Object> cache;
    private EntityLookupCache<Long, Object, String> entityLookupCacheA;
    private EntityLookupCache<Long, Object, String> entityLookupCacheB;
    private TreeMap<Long, String> database;

    protected void setUp() throws Exception {
        this.cache = new MemoryCache();
        this.entityLookupCacheA = new EntityLookupCache<Long, Object, String>(this.cache, "A", this);
        this.entityLookupCacheB = new EntityLookupCache<Long, Object, String>(this.cache, "B", this);
        this.database = new TreeMap();
    }

    public void testLookupsUsingIncorrectValue() throws Exception {
        try {
            this.entityLookupCacheA.getByValue(this);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testLookupAgainstEmpty() throws Exception {
        TestValue value = new TestValue("AAA");
        Pair<Long, Object> entityPair = this.entityLookupCacheA.getByValue(value);
        EntityLookupCacheTest.assertNull(entityPair);
        EntityLookupCacheTest.assertTrue((boolean)this.database.isEmpty());
        entityPair = this.entityLookupCacheA.getOrCreateByValue(value);
        EntityLookupCacheTest.assertNotNull((String)"Expected a value to be found", entityPair);
        Long entityId = (Long)entityPair.getFirst();
        EntityLookupCacheTest.assertTrue((String)"Database ID should have been created", (boolean)this.database.containsKey(entityId));
        EntityLookupCacheTest.assertEquals((String)"Database value incorrect", (String)value.val, (String)this.database.get(entityId));
        entityPair = this.entityLookupCacheA.getOrCreateByValue(value);
        EntityLookupCacheTest.assertNotNull((String)"Expected a value to be found", entityPair);
        EntityLookupCacheTest.assertEquals((String)"Expected same entity ID", (Object)entityId, (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByValue(value);
        EntityLookupCacheTest.assertNotNull((String)"Lookup after create should work", entityPair);
        entityPair = this.entityLookupCacheA.getByKey(entityId);
        EntityLookupCacheTest.assertNotNull((String)"Lookup by key should work after create", entityPair);
        EntityLookupCacheTest.assertTrue((String)"Looked-up type incorrect", (boolean)(entityPair.getSecond() instanceof TestValue));
        EntityLookupCacheTest.assertEquals((String)"Looked-up type value incorrect", (Object)value, (Object)entityPair.getSecond());
    }

    public void testLookupAgainstExisting() throws Exception {
        this.createValue(new TestValue("AAA"));
        this.createValue(new TestValue("BBB"));
        this.createValue(new TestValue("CCC"));
        Pair<Long, Object> entityPair = this.entityLookupCacheA.getByValue(new TestValue("AAA"));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", entityPair);
        EntityLookupCacheTest.assertEquals((String)"ID is incorrect", (Object)new Long(1L), (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByKey(new Long(2L));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", entityPair);
        entityPair = this.entityLookupCacheA.getByValue(new TestValue("CCC"));
        EntityLookupCacheTest.assertNotNull((String)"Expected value to be found", entityPair);
        EntityLookupCacheTest.assertEquals((String)"ID is incorrect", (Object)new Long(3L), (Object)entityPair.getFirst());
    }

    public void testRegions() throws Exception {
        TestValue valueAAA = new TestValue("AAA");
        Pair<Long, Object> entityPairAAA = this.entityLookupCacheA.getOrCreateByValue(valueAAA);
        EntityLookupCacheTest.assertNotNull(entityPairAAA);
        EntityLookupCacheTest.assertEquals((String)"AAA", (String)this.database.get(entityPairAAA.getFirst()));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        TestValue valueBBB = new TestValue("BBB");
        Pair<Long, Object> entityPairBBB = this.entityLookupCacheB.getOrCreateByValue(valueBBB);
        EntityLookupCacheTest.assertNotNull(entityPairBBB);
        EntityLookupCacheTest.assertEquals((String)"BBB", (String)this.database.get(entityPairBBB.getFirst()));
        EntityLookupCacheTest.assertEquals((int)4, (int)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheA.getByValue(valueBBB);
        EntityLookupCacheTest.assertEquals((int)6, (int)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheB.getByValue(valueAAA);
        EntityLookupCacheTest.assertEquals((int)8, (int)this.cache.getKeys().size());
    }

    public void testNullLookups() throws Exception {
        Object valueNull = null;
        Pair<Long, Object> entityPairNull = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        EntityLookupCacheTest.assertNotNull(entityPairNull);
        EntityLookupCacheTest.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        Pair<Long, Object> entityPairCheck = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        EntityLookupCacheTest.assertNotNull(entityPairNull);
        EntityLookupCacheTest.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        EntityLookupCacheTest.assertEquals(entityPairNull, entityPairCheck);
    }

    public void testUpdate() throws Exception {
        TestValue valueOne = new TestValue(this.getName() + "-ONE");
        TestValue valueTwo = new TestValue(this.getName() + "-TWO");
        Pair<Long, Object> entityPairOne = this.entityLookupCacheA.getOrCreateByValue(valueOne);
        EntityLookupCacheTest.assertNotNull(entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int updateCount = this.entityLookupCacheA.updateValue(id, valueTwo);
        EntityLookupCacheTest.assertEquals((String)"Update count was incorrect.", (int)1, (int)updateCount);
        EntityLookupCacheTest.assertEquals((String)valueTwo.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
    }

    public void testDeleteByKey() throws Exception {
        TestValue valueOne = new TestValue(this.getName() + "-ONE");
        Pair<Long, Object> entityPairOne = this.entityLookupCacheA.getOrCreateByValue(valueOne);
        EntityLookupCacheTest.assertNotNull(entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByKey(id);
        EntityLookupCacheTest.assertEquals((String)"Delete count was incorrect.", (int)1, (int)deleteCount);
        EntityLookupCacheTest.assertNull((Object)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    public void testDeleteByValue() throws Exception {
        TestValue valueOne = new TestValue(this.getName() + "-ONE");
        Pair<Long, Object> entityPairOne = this.entityLookupCacheA.getOrCreateByValue(valueOne);
        EntityLookupCacheTest.assertNotNull(entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByValue(valueOne);
        EntityLookupCacheTest.assertEquals((String)"Delete count was incorrect.", (int)1, (int)deleteCount);
        EntityLookupCacheTest.assertNull((Object)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    public void testClear() throws Exception {
        TestValue valueOne = new TestValue(this.getName() + "-ONE");
        Pair<Long, Object> entityPairOne = this.entityLookupCacheA.getOrCreateByValue(valueOne);
        EntityLookupCacheTest.assertNotNull(entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)2, (int)this.cache.getKeys().size());
        this.entityLookupCacheA.clear();
        EntityLookupCacheTest.assertEquals((String)valueOne.val, (String)this.database.get(id));
        EntityLookupCacheTest.assertEquals((int)0, (int)this.cache.getKeys().size());
    }

    @Override
    public String getValueKey(Object value) {
        EntityLookupCacheTest.assertNotNull((Object)value);
        EntityLookupCacheTest.assertTrue((boolean)(value instanceof TestValue));
        String dbValue = ((TestValue)value).val;
        return dbValue;
    }

    @Override
    public Pair<Long, Object> findByKey(Long key) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        String dbValue = this.database.get(key);
        if (dbValue == null) {
            return null;
        }
        TestValue value = new TestValue(dbValue);
        return new Pair((Object)key, (Object)value);
    }

    @Override
    public Pair<Long, Object> findByValue(Object value) {
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String dbValue = value == null ? null : ((TestValue)value).val;
        for (Map.Entry<Long, String> entry : this.database.entrySet()) {
            if (!EqualsHelper.nullSafeEquals((Object)entry.getValue(), (Object)dbValue)) continue;
            return new Pair((Object)entry.getKey(), (Object)entry.getValue());
        }
        return null;
    }

    @Override
    public Pair<Long, Object> createValue(Object value) {
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String dbValue = value == null ? null : ((TestValue)value).val;
        Long lastKey = this.database.isEmpty() ? null : this.database.lastKey();
        Long newKey = null;
        newKey = lastKey == null ? new Long(1L) : new Long(lastKey + 1L);
        this.database.put(newKey, dbValue);
        return new Pair((Object)newKey, value);
    }

    @Override
    public int updateValue(Long key, Object value) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByKey(key);
        if (entityPair == null) {
            return 0;
        }
        this.database.put(key, ((TestValue)value).val);
        return 1;
    }

    @Override
    public int deleteByKey(Long key) {
        EntityLookupCacheTest.assertNotNull((Object)key);
        if (this.database.containsKey(key)) {
            this.database.remove(key);
            return 1;
        }
        return 0;
    }

    @Override
    public int deleteByValue(Object value) {
        EntityLookupCacheTest.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByValue(value);
        if (entityPair == null) {
            return 0;
        }
        this.database.remove(entityPair.getFirst());
        return 1;
    }

    private static class TestValue {
        private final String val;

        private TestValue(String val) {
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TestValue)) {
                return false;
            }
            return this.val.equals(((TestValue)obj).val);
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

