/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentAccessor;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentWriter
extends AbstractContentAccessor
implements ContentWriter {
    private static final Log logger = LogFactory.getLog(AbstractContentWriter.class);
    private List<ContentStreamListener> listeners;
    private WritableByteChannel channel;
    private ContentReader existingContentReader;

    protected AbstractContentWriter(String contentUrl, ContentReader existingContentReader) {
        super(contentUrl);
        this.existingContentReader = existingContentReader;
        this.listeners = new ArrayList<ContentStreamListener>(2);
    }

    protected ContentReader getExistingContentReader() {
        return this.existingContentReader;
    }

    public synchronized void addListener(ContentStreamListener listener) {
        if (this.channel != null) {
            throw new RuntimeException("Channel is already in use");
        }
        this.listeners.add(listener);
    }

    protected abstract ContentReader createReader() throws ContentIOException;

    public final ContentReader getReader() throws ContentIOException {
        String contentUrl = this.getContentUrl();
        if (!this.isClosed()) {
            return new EmptyContentReader(contentUrl);
        }
        ContentReader reader = this.createReader();
        if (reader == null) {
            throw new AlfrescoRuntimeException("ContentReader failed to create new reader: \n   writer: " + this);
        }
        if (reader.getContentUrl() == null || !reader.getContentUrl().equals(contentUrl)) {
            throw new AlfrescoRuntimeException("ContentReader has different URL: \n   writer: " + this + "\n" + "   new reader: " + reader);
        }
        reader.setMimetype(this.getMimetype());
        reader.setEncoding(this.getEncoding());
        reader.setLocale(this.getLocale());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writer spawned new reader: \n   writer: " + this + "\n" + "   new reader: " + reader));
        }
        return reader;
    }

    public final synchronized boolean isClosed() {
        if (this.channel != null) {
            return !this.channel.isOpen();
        }
        return false;
    }

    public synchronized boolean isChannelOpen() {
        if (this.channel != null) {
            return this.channel.isOpen();
        }
        return false;
    }

    protected abstract WritableByteChannel getDirectWritableChannel() throws ContentIOException;

    private WritableByteChannel getCallbackWritableChannel(WritableByteChannel directChannel, List<ContentStreamListener> listeners) throws ContentIOException {
        WritableByteChannel callbackChannel = null;
        if (directChannel instanceof FileChannel) {
            callbackChannel = this.getCallbackFileChannel((FileChannel)directChannel, listeners);
        } else {
            AbstractContentAccessor.ChannelCloseCallbackAdvise advise = new AbstractContentAccessor.ChannelCloseCallbackAdvise(listeners);
            ProxyFactory proxyFactory = new ProxyFactory((Object)directChannel);
            proxyFactory.addAdvice((Advice)advise);
            callbackChannel = (WritableByteChannel)proxyFactory.getProxy();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created callback byte channel: \n   original: " + directChannel + "\n" + "   new: " + callbackChannel));
        }
        return callbackChannel;
    }

    public final synchronized WritableByteChannel getWritableChannel() throws ContentIOException {
        if (this.channel != null) {
            throw new ContentIOException("A channel has already been opened");
        }
        WritableByteChannel directChannel = this.getDirectWritableChannel();
        this.channel = this.getCallbackWritableChannel(directChannel, this.listeners);
        super.channelOpened();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opened channel onto content: \n   content: " + this + "\n" + "   channel: " + this.channel));
        }
        return this.channel;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileChannel getFileChannel(boolean truncate) throws ContentIOException {
        this.channel = this.getWritableChannel();
        FileChannel clientFileChannel = null;
        if (!(this.channel instanceof FileChannel)) {
            File tempFile = TempFileProvider.createTempFile((String)"random_write_spoof_", (String)".bin");
            final FileContentWriter spoofWriter = new FileContentWriter(tempFile, this.getExistingContentReader());
            ContentStreamListener spoofListener = new ContentStreamListener(){

                /*
                 * Loose catch block
                 */
                public void contentStreamClosed() throws ContentIOException {
                    ContentReader spoofReader = spoofWriter.getReader();
                    FileChannel spoofChannel = spoofReader.getFileChannel();
                    long spoofFileSize = spoofChannel.size();
                    spoofChannel.transferTo(0L, spoofFileSize, AbstractContentWriter.this.channel);
                    Object var6_5 = null;
                    try {
                        spoofChannel.close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        AbstractContentWriter.this.channel.close();
                    }
                    catch (IOException e) {
                        throw new ContentIOException("Failed to close underlying channel", e);
                    }
                    {
                        catch (IOException e) {
                            throw new ContentIOException("Failed to copy from spoofed temporary channel to permanent channel: \n   writer: " + this + "\n" + "   temp: " + spoofReader, (Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        try {
                            spoofChannel.close();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            AbstractContentWriter.this.channel.close();
                        }
                        catch (IOException e) {
                            throw new ContentIOException("Failed to close underlying channel", e);
                        }
                        throw throwable;
                    }
                }
            };
            spoofWriter.addListener(spoofListener);
            clientFileChannel = spoofWriter.getFileChannel(truncate);
            if (!logger.isDebugEnabled()) return clientFileChannel;
            logger.debug((Object)("Content writer provided indirect support for FileChannel: \n   writer: " + this + "\n" + "   temp writer: " + spoofWriter));
            return clientFileChannel;
        }
        clientFileChannel = (FileChannel)this.channel;
        if (!truncate && this.existingContentReader != null) {
            ReadableByteChannel existingContentChannel = this.existingContentReader.getReadableChannel();
            long existingContentLength = this.existingContentReader.getSize();
            try {
                try {
                    clientFileChannel.transferFrom(existingContentChannel, 0L, existingContentLength);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Copied content for random access: \n   writer: " + this + "\n" + "   existing: " + this.existingContentReader));
                    }
                }
                catch (IOException e) {
                    throw new ContentIOException("Failed to copy from existing content to enable random access: \n   writer: " + this + "\n" + "   existing: " + this.existingContentReader, (Throwable)e);
                }
                Object var8_7 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    existingContentChannel.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            existingContentChannel.close();
        }
        if (!logger.isDebugEnabled()) return clientFileChannel;
        logger.debug((Object)("Content writer provided direct support for FileChannel: \n   writer: " + this));
        return clientFileChannel;
    }

    public OutputStream getContentOutputStream() throws ContentIOException {
        try {
            WritableByteChannel channel = this.getWritableChannel();
            BufferedOutputStream is = new BufferedOutputStream(Channels.newOutputStream(channel));
            return is;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to open stream onto channel: \n   writer: " + this, e);
        }
    }

    public void putContent(ContentReader reader) throws ContentIOException {
        try {
            InputStream is = reader.getContentInputStream();
            this.putContent(is);
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to copy reader content to writer: \n   writer: " + this + "\n" + "   source reader: " + reader, e);
        }
    }

    public final void putContent(InputStream is) throws ContentIOException {
        try {
            OutputStream os = this.getContentOutputStream();
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from input stream: \n   writer: " + this, (Throwable)e);
        }
    }

    public final void putContent(File file) throws ContentIOException {
        try {
            OutputStream os = this.getContentOutputStream();
            FileInputStream is = new FileInputStream(file);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from file: \n   writer: " + this + "\n" + "   file: " + file, (Throwable)e);
        }
    }

    public final void putContent(String content) throws ContentIOException {
        try {
            String encoding = this.getEncoding();
            byte[] bytes = encoding == null ? content.getBytes() : content.getBytes(encoding);
            OutputStream os = this.getContentOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to copy content from string: \n   writer: " + this + "   content length: " + content.length(), (Throwable)e);
        }
    }
}

