/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import org.alfresco.repo.content.metadata.OpenOfficeMetadataWorker;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.TempFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOpenOfficeMetadataWorker
implements OpenOfficeMetadataWorker {
    private static final String KEY_AUTHOR = "author";
    private static final String KEY_TITLE = "title";
    private static final String KEY_DESCRIPTION = "description";
    private OpenOfficeConnection connection;
    private MimetypeService mimetypeService;

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    @Override
    public boolean isConnected() {
        return this.connection.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        HashMap<String, Serializable> rawProperties = new HashMap<String, Serializable>(17);
        String sourceMimetype = reader.getMimetype();
        File tempFromFile = TempFileProvider.createTempFile((String)"OpenOfficeMetadataExtracter-", (String)("." + this.mimetypeService.getExtension(sourceMimetype)));
        reader.getContent(tempFromFile);
        String sourceUrl = this.toUrl(tempFromFile, this.connection);
        XComponentLoader desktop = this.connection.getDesktop();
        XComponent document = desktop.loadComponentFromURL(sourceUrl, "_blank", 0, new PropertyValue[]{DefaultOpenOfficeMetadataWorker.property("Hidden", Boolean.TRUE)});
        if (document == null) {
            throw new FileNotFoundException("could not open source document: " + sourceUrl);
        }
        try {
            XDocumentInfoSupplier infoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)document);
            XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)infoSupplier.getDocumentInfo());
            rawProperties.put(KEY_TITLE, (Serializable)((Object)propSet.getPropertyValue("Title").toString()));
            rawProperties.put(KEY_DESCRIPTION, (Serializable)((Object)propSet.getPropertyValue("Subject").toString()));
            rawProperties.put(KEY_AUTHOR, (Serializable)((Object)propSet.getPropertyValue("Author").toString()));
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            document.dispose();
            throw throwable;
        }
        document.dispose();
        return rawProperties;
    }

    public String toUrl(File file, OpenOfficeConnection connection) throws ConnectException {
        XFileIdentifierConverter fcp = connection.getFileContentProvider();
        XFileIdentifierConverter fic = (XFileIdentifierConverter)UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)fcp);
        return fic.getFileURLFromSystemPath("", file.getAbsolutePath());
    }

    private static PropertyValue property(String name, Object value) {
        PropertyValue property = new PropertyValue();
        property.Name = name;
        property.Value = value;
        return property;
    }
}

