/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.OpenDocumentMetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDocumentMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private OpenDocumentMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new OpenDocumentMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : OpenDocumentMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            OpenDocumentMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        for (String mimetype : OpenDocumentMetadataExtracter.SUPPORTED_MIMETYPES) {
            this.testExtractFromMimetype(mimetype);
        }
    }

    @Override
    protected boolean skipAuthorCheck(String mimetype) {
        return true;
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        if (mimetype.equals("application/vnd.oasis.opendocument.text")) {
            OpenDocumentMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"2005-09-06T23:34:00.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
        } else if (mimetype.equals("application/vnd.oasis.opendocument.graphics")) {
            OpenDocumentMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"2006-01-27T11:46:11.000Z", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
        }
    }
}

