/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.PdfBoxMetadataExtracter;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.pdfbox.util.DateConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfBoxMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private PdfBoxMetadataExtracter extracter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.extracter = new PdfBoxMetadataExtracter();
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        for (String mimetype : PdfBoxMetadataExtracter.SUPPORTED_MIMETYPES) {
            boolean supports = this.extracter.isSupported(mimetype);
            PdfBoxMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testPdfExtraction() throws Exception {
        this.testExtractFromMimetype("application/pdf");
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        PdfBoxMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_CREATED + " not found for mimetype " + mimetype), (String)"2005-05-26T20:52:58.000+01:00", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))));
    }

    public void testDateConversion() throws Exception {
        Calendar c = DateConverter.toCalendar((String)"D:20050526205258+01'00'");
        PdfBoxMetadataExtracterTest.assertEquals((int)2005, (int)c.get(1));
        PdfBoxMetadataExtracterTest.assertEquals((int)4, (int)c.get(2));
        PdfBoxMetadataExtracterTest.assertEquals((int)26, (int)c.get(5));
        PdfBoxMetadataExtracterTest.assertEquals((int)20, (int)c.get(11));
        PdfBoxMetadataExtracterTest.assertEquals((int)52, (int)c.get(12));
        PdfBoxMetadataExtracterTest.assertEquals((int)58, (int)c.get(13));
    }
}

