/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata.xml;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.xml.XPathMetadataExtracter;
import org.alfresco.repo.content.selector.ContentWorkerSelector;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMetadataExtracter
extends AbstractMappingMetadataExtracter {
    public static String[] SUPPORTED_MIMETYPES = new String[]{"text/xml"};
    private static Log logger = LogFactory.getLog(XPathMetadataExtracter.class);
    private List<ContentWorkerSelector<MetadataExtracter>> selectors;

    public XmlMetadataExtracter() {
        super(new HashSet<String>(Arrays.asList(SUPPORTED_MIMETYPES)));
    }

    public void setSelectors(List<ContentWorkerSelector<MetadataExtracter>> selectors) {
        this.selectors = selectors;
    }

    @Override
    protected void init() {
        PropertyCheck.mandatory((Object)this, (String)"selectors", this.selectors);
        super.init();
    }

    @Override
    protected Map<String, Set<QName>> getDefaultMapping() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<QName, Serializable> extract(ContentReader reader, MetadataExtracter.OverwritePolicy overwritePolicy, Map<QName, Serializable> destination, Map<String, Set<QName>> mapping) {
        if (reader.getSize() == 0L) {
            if (!logger.isDebugEnabled()) return destination;
            logger.debug((Object)("\nXML document has zero length, so bypassing extraction: \n   Document: " + reader));
            return destination;
        }
        MetadataExtracter extracter = null;
        Iterator<ContentWorkerSelector<MetadataExtracter>> i$ = this.selectors.iterator();
        if (i$.hasNext()) {
            ContentWorkerSelector<MetadataExtracter> selector = i$.next();
            ContentReader spawnedReader = reader.getReader();
            try {
                extracter = selector.getWorker(spawnedReader);
                return extracter;
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (!reader.isChannelOpen()) throw throwable;
                logger.error((Object)("Content reader not closed by MetadataExtractor selector: \n   reader:   " + reader + "\n" + "   selector: " + selector));
                throw throwable;
            }
        }
        Map<QName, Serializable> modifiedProperties = null;
        if (extracter == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\nNo working metadata extractor could be found: \n   Document: " + reader));
            }
            modifiedProperties = destination;
        } else {
            try {
                modifiedProperties = extracter.extract(reader, overwritePolicy, destination, mapping);
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (!reader.isChannelOpen()) throw throwable;
                logger.error((Object)("Content reader not closed by MetadataExtractor: \n   Reader:   " + reader + "\n" + "   extracter: " + extracter));
                throw throwable;
            }
            if (reader.isChannelOpen()) {
                logger.error((Object)("Content reader not closed by MetadataExtractor: \n   Reader:   " + reader + "\n" + "   extracter: " + extracter));
            }
        }
        if (!logger.isDebugEnabled()) return modifiedProperties;
        logger.debug((Object)("\nXML metadata extractor redirected: \n   Reader:    " + reader + "\n" + "   Extracter: " + extracter + "\n" + "   Metadata: " + modifiedProperties));
        return modifiedProperties;
    }

    @Override
    protected Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
        throw new UnsupportedOperationException();
    }
}

