/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.selector;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.ContentWorker;
import org.alfresco.repo.content.selector.ContentWorkerSelector;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathContentWorkerSelector<W extends ContentWorker>
implements ContentWorkerSelector {
    private static Log logger = LogFactory.getLog(XPathContentWorkerSelector.class);
    private DocumentBuilder documentBuilder;
    private XPathFactory xpathFactory;
    private Set<String> supportedMimetypes;
    private Map<String, W> workersByXPath;

    public XPathContentWorkerSelector() {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.xpathFactory = XPathFactory.newInstance();
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to initialize XPathContentWorkerSelector", e);
        }
        this.supportedMimetypes = new HashSet<String>();
        this.supportedMimetypes.add("text/xml");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append("XPathContentWorkerSelector").append("[ workers=").append(this.workersByXPath).append("]");
        return sb.toString();
    }

    public void setSupportedMimetypes(Set<String> supportedMimetypes) {
        this.supportedMimetypes = supportedMimetypes;
    }

    public void setWorkers(Map<String, W> workers) {
        this.workersByXPath = workers;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"workers", this.workersByXPath);
        PropertyCheck.mandatory((Object)this, (String)"supportedMimetypes", this.supportedMimetypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public W getWorker(ContentReader reader) {
        String xpath;
        W worker;
        block8: {
            if (!this.supportedMimetypes.contains(reader.getMimetype())) {
                return null;
            }
            worker = null;
            InputStream is = null;
            xpath = null;
            try {
                try {
                    is = reader.getContentInputStream();
                    Document doc = this.documentBuilder.parse(is);
                    worker = this.processDocument(doc);
                }
                catch (Throwable e) {
                    throw new ContentIOException("\nFailed to XPaths against XML document: \n   Reader:   " + reader + "\n" + "   Selector: " + this, e);
                }
                Object var7_7 = null;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            is.close();
        }
        if (!logger.isDebugEnabled()) return worker;
        logger.debug((Object)("\nChosen content worker for reader: \n   Reader:       " + reader + "\n" + "   XPath:        " + xpath + "\n" + "   Worker:    " + worker));
        return worker;
    }

    private W processDocument(Document doc) {
        for (Map.Entry<String, W> entry : this.workersByXPath.entrySet()) {
            try {
                String xpath = entry.getKey();
                ContentWorker worker = (ContentWorker)entry.getValue();
                Object ret = this.xpathFactory.newXPath().evaluate(xpath, doc, XPathConstants.NODE);
                if (ret == null) continue;
                return (W)worker;
            }
            catch (XPathExpressionException e) {
            }
        }
        return null;
    }
}

