/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pkg.PackageParser;

public class ArchiveContentTransformer
extends TikaPoweredContentTransformer {
    private static Log logger = LogFactory.getLog(ArchiveContentTransformer.class);
    private boolean includeContents = false;
    public static ArrayList<String> SUPPORTED_MIMETYPES = new ArrayList();

    public void setIncludeContents(String includeContents) {
        this.includeContents = false;
        if (includeContents != null && includeContents.length() > 0 && (includeContents.equalsIgnoreCase("true") || includeContents.equalsIgnoreCase("t") || includeContents.equalsIgnoreCase("yes") || includeContents.equalsIgnoreCase("y"))) {
            this.includeContents = true;
        }
    }

    public ArchiveContentTransformer() {
        super(SUPPORTED_MIMETYPES);
    }

    protected Parser getParser() {
        return new PackageParser();
    }

    protected ParseContext buildParseContext(Metadata metadata, String targetMimeType, TransformationOptions options) {
        ParseContext context = super.buildParseContext(metadata, targetMimeType, options);
        boolean recurse = this.includeContents;
        if (options.getIncludeEmbedded() != null) {
            recurse = options.getIncludeEmbedded();
        }
        System.err.println(this.includeContents + " " + recurse + " " + options.getIncludeEmbedded());
        if (recurse) {
            context.set(Parser.class, (Object)new AutoDetectParser());
        }
        return context;
    }

    static {
        PackageParser p = new PackageParser();
        for (MediaType mt : p.getSupportedTypes(null)) {
            SUPPORTED_MIMETYPES.add(mt.toString());
        }
    }
}

