/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class MailContentTransformer
extends AbstractContentTransformer2 {
    private static final Log logger = LogFactory.getLog(MailContentTransformer.class);
    private static final String STREAM_PREFIX = "__substg1.0_";
    private static final int STREAM_PREFIX_LENGTH = "__substg1.0_".length();
    private static final String ENCODING_TEXT = "001E";
    private static final String ENCODING_BINARY = "0102";
    private static final String ENCODING_UNICODE = "001F";
    private static final String SUBSTG_MESSAGEBODY = "1000";

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return "application/vnd.ms-outlook".equals(sourceMimetype) && "text/plain".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        final StringBuilder sb = new StringBuilder();
        POIFSReaderListener readerListener = new POIFSReaderListener(){

            public void processPOIFSReaderEvent(POIFSReaderEvent event) {
                try {
                    StreamHandler handler;
                    String result;
                    if (event.getName().startsWith(MailContentTransformer.STREAM_PREFIX) && (result = (handler = new StreamHandler(event.getName(), event.getStream())).process()) != null) {
                        sb.append(result);
                    }
                }
                catch (Exception ex) {
                    throw new ContentIOException("Property set stream: " + event.getPath() + event.getName(), (Throwable)ex);
                }
            }
        };
        InputStream is = null;
        try {
            block10: {
                is = reader.getContentInputStream();
                POIFSReader poiFSReader = new POIFSReader();
                poiFSReader.registerListener(readerListener);
                try {
                    try {
                        poiFSReader.read(is);
                    }
                    catch (IOException err) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Unable to extract text from message: " + err.getMessage()));
                        }
                        Object var10_9 = null;
                        writer.putContent(sb.toString());
                        break block10;
                    }
                    Object var10_8 = null;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    writer.putContent(sb.toString());
                    throw throwable;
                }
                writer.putContent(sb.toString());
            }
            Object var12_13 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            return;
        }
        is.close();
    }

    private class StreamHandler {
        private String type;
        private String encoding;
        private DocumentInputStream stream;

        StreamHandler(String name, DocumentInputStream stream) {
            this.type = name.substring(STREAM_PREFIX_LENGTH, STREAM_PREFIX_LENGTH + 4);
            this.encoding = name.substring(STREAM_PREFIX_LENGTH + 4, STREAM_PREFIX_LENGTH + 8);
            this.stream = stream;
        }

        String process() throws IOException {
            String result = null;
            if (MailContentTransformer.SUBSTG_MESSAGEBODY.equals(this.type)) {
                result = this.extractText(this.encoding);
            }
            return result;
        }

        private String extractText(String encoding) throws IOException {
            byte[] data = new byte[this.stream.available()];
            this.stream.read(data);
            if (encoding.equals(MailContentTransformer.ENCODING_TEXT) || encoding.equals(MailContentTransformer.ENCODING_BINARY)) {
                return new String(data);
            }
            if (encoding.equals(MailContentTransformer.ENCODING_UNICODE)) {
                byte[] b = new byte[data.length >> 1];
                for (int i = 0; i < b.length; ++i) {
                    b[i] = data[i << 1];
                }
                return new String(b);
            }
            return new String(data);
        }
    }
}

