/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jooreports.converter.DocumentFamily;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.converter.XmlDocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import net.sf.jooreports.openoffice.converter.StreamOpenOfficeDocumentConverter;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer;
import org.alfresco.service.cmr.repository.ContentAccessor;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.springframework.core.io.DefaultResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteOpenOfficeContentTransformer
extends AbstractContentTransformer {
    private OpenOfficeConnection connection;
    private StreamOpenOfficeDocumentConverter converter;
    private String documentFormatsConfiguration;
    private DocumentFormatRegistry formatRegistry;

    public void setConnection(OpenOfficeConnection connection) {
        this.connection = connection;
    }

    public void setDocumentFormatsConfiguration(String path) {
        this.documentFormatsConfiguration = path;
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    @Override
    public void register() {
        PropertyCheck.mandatory((Object)"OpenOfficeContentTransformer", (String)"connection", (Object)this.connection);
        if (this.documentFormatsConfiguration != null) {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            try {
                InputStream is = resourceLoader.getResource(this.documentFormatsConfiguration).getInputStream();
                this.formatRegistry = new XmlDocumentFormatRegistry(is);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to load document formats configuration file: " + this.documentFormatsConfiguration);
            }
        } else {
            this.formatRegistry = new XmlDocumentFormatRegistry();
        }
        this.converter = new StreamOpenOfficeDocumentConverter(this.connection);
        super.register();
    }

    @Override
    public double getReliability(String sourceMimetype, String targetMimetype) {
        if (!this.isConnected()) {
            return 0.0;
        }
        if (targetMimetype.equals("application/xhtml+xml")) {
            return 0.0;
        }
        if (targetMimetype.equals("application/wordperfect")) {
            return 0.0;
        }
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            return 0.0;
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            return 0.0;
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        if (!targetFormat.isExportableFrom(sourceFamily)) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    protected void transformInternal(ContentReader reader, ContentWriter writer, Map<String, Object> options) throws Exception {
        String sourceMimetype = this.getMimetype((ContentAccessor)reader);
        String targetMimetype = this.getMimetype((ContentAccessor)writer);
        MimetypeService mimetypeService = this.getMimetypeService();
        String sourceExtension = mimetypeService.getExtension(sourceMimetype);
        String targetExtension = mimetypeService.getExtension(targetMimetype);
        DocumentFormat sourceFormat = this.formatRegistry.getFormatByFileExtension(sourceExtension);
        if (sourceFormat == null) {
            throw new ContentIOException("No OpenOffice document format for source extension: " + sourceExtension);
        }
        DocumentFormat targetFormat = this.formatRegistry.getFormatByFileExtension(targetExtension);
        if (targetFormat == null) {
            throw new ContentIOException("No OpenOffice document format for target extension: " + targetExtension);
        }
        DocumentFamily sourceFamily = sourceFormat.getFamily();
        if (!targetFormat.isExportableFrom(sourceFamily)) {
            throw new ContentIOException("OpenOffice conversion not supported: \n   reader: " + reader + "\n" + "   writer: " + writer);
        }
        File tempFromFile = TempFileProvider.createTempFile((String)"OpenOfficeContentTransformer-source-", (String)("." + sourceExtension));
        File tempToFile = TempFileProvider.createTempFile((String)"OpenOfficeContentTransformer-target-", (String)("." + targetExtension));
        reader.getContent(tempFromFile);
        try {
            this.converter.convert(tempFromFile, sourceFormat, tempToFile, targetFormat);
        }
        catch (OpenOfficeException e) {
            throw new ContentIOException("OpenOffice server conversion failed: \n   reader: " + reader + "\n" + "   writer: " + writer + "\n" + "   from file: " + tempFromFile + "\n" + "   to file: " + tempToFile, (Throwable)e);
        }
        writer.putContent(tempToFile);
    }
}

