/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringExtractingContentTransformer
extends AbstractContentTransformer2 {
    public static final String PREFIX_TEXT = "text/";
    private static final Log logger = LogFactory.getLog(StringExtractingContentTransformer.class);

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!targetMimetype.equals("text/plain")) {
            return false;
        }
        if (sourceMimetype.equals("text/plain") || sourceMimetype.equals("application/x-javascript")) {
            return true;
        }
        return sourceMimetype.startsWith(PREFIX_TEXT);
    }

    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        this.transformText(reader, writer, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformText(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        Throwable e22;
        Writer charWriter;
        block12: {
            InputStreamReader charReader = null;
            charWriter = null;
            try {
                charReader = reader.getEncoding() == null ? new InputStreamReader(reader.getContentInputStream()) : new InputStreamReader(reader.getContentInputStream(), reader.getEncoding());
                charWriter = writer.getEncoding() == null ? new OutputStreamWriter(writer.getContentOutputStream()) : new OutputStreamWriter(writer.getContentOutputStream(), writer.getEncoding());
                char[] buffer = new char[1024];
                int readCount = 0;
                while (readCount > -1) {
                    charWriter.write(buffer, 0, readCount);
                    readCount = charReader.read(buffer);
                }
                Object var9_8 = null;
                if (charReader == null) break block12;
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var9_9 = null;
                if (charReader != null) {
                    try {
                        ((Reader)charReader).close();
                    }
                    catch (Throwable e22) {
                        logger.error((Object)e22);
                    }
                }
                if (charWriter != null) {
                    try {
                        charWriter.close();
                    }
                    catch (Throwable e22) {
                        logger.error((Object)e22);
                    }
                }
                throw throwable;
            }
            try {
                ((Reader)charReader).close();
            }
            catch (Throwable e22) {
                logger.error((Object)e22);
            }
        }
        if (charWriter != null) {
            try {
                charWriter.close();
            }
            catch (Throwable e22) {
                logger.error((Object)e22);
            }
        }
    }
}

