/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Random;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.StringExtractingContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class StringExtractingContentTransformerTest
extends AbstractContentTransformerTest {
    private static final String SOME_CONTENT;
    private ContentTransformer transformer;
    private ContentWriter targetWriter;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new StringExtractingContentTransformer();
        this.targetWriter = new FileContentWriter(this.getTempFile());
        this.targetWriter.setMimetype("text/plain");
        this.targetWriter.setEncoding("UTF-8");
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testSetUp() throws Exception {
        StringExtractingContentTransformerTest.assertNotNull((Object)this.transformer);
    }

    private File getTempFile() {
        return TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
    }

    private ContentReader writeContent(String mimetype, String encoding) {
        FileContentWriter writer = new FileContentWriter(this.getTempFile());
        writer.setMimetype(mimetype);
        writer.setEncoding(encoding);
        writer.putContent(SOME_CONTENT);
        return writer.getReader();
    }

    public void testDirectTransform() throws Exception {
        ContentReader reader = this.writeContent("text/plain", "MacDingbat");
        StringExtractingContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable(reader.getMimetype(), this.targetWriter.getMimetype(), new TransformationOptions()));
        this.transformer.transform(reader, this.targetWriter);
        ContentReader checkReader = this.targetWriter.getReader();
        String checkContent = checkReader.getContentString();
        StringExtractingContentTransformerTest.assertEquals((String)"Content check failed", (String)SOME_CONTENT, (String)checkContent);
    }

    public void testInterTextTransform() throws Exception {
        ContentReader reader = this.writeContent("text/xml", "MacDingbat");
        StringExtractingContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable(reader.getMimetype(), this.targetWriter.getMimetype(), new TransformationOptions()));
        this.transformer.transform(reader, this.targetWriter);
        ContentReader checkReader = this.targetWriter.getReader();
        String checkContent = checkReader.getContentString();
        StringExtractingContentTransformerTest.assertEquals((String)"Content check failed", (String)SOME_CONTENT, (String)checkContent);
    }

    public void testLargeFileStreaming() throws Exception {
        File sourceFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        int chars = 1000000;
        Random random = new Random();
        OutputStreamWriter charWriter = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(sourceFile)));
        for (int i = 0; i < chars; ++i) {
            char next = (char)(random.nextDouble() * 93.0 + 32.0);
            ((Writer)charWriter).write(next);
        }
        ((Writer)charWriter).close();
        FileContentReader reader = new FileContentReader(sourceFile);
        reader.setMimetype("text/plain");
        File outputFile = TempFileProvider.createTempFile((String)this.getName(), (String)".txt");
        FileContentWriter writer = new FileContentWriter(outputFile);
        writer.setMimetype("text/plain");
        this.transformer.transform(reader, writer);
        sourceFile.delete();
        outputFile.delete();
    }

    static {
        try {
            SOME_CONTENT = new String("azAz10!\ufffd$%^&*()\t\r\n".getBytes("UTF-8"), "MacDingbat");
        }
        catch (UnsupportedEncodingException e) {
            throw new AlfrescoRuntimeException("Encoding not recognised", (Throwable)e);
        }
    }
}

