/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TikaAutoContentTransformer;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformerTest;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class TikaAutoContentTransformerTest
extends TikaPoweredContentTransformerTest {
    private ContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new TikaAutoContentTransformer();
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/vnd.ms-excel", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/msword", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/pdf", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", "application/vnd.oasis.opendocument.presentation", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/x-mpeg", "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/x-mpeg", "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/x-mpeg", "text/xml", new TransformationOptions()));
    }
}

