/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.deploy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.util.BulkLoader;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.deploy.DeploymentCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentEvent;
import org.alfresco.service.cmr.avm.deploy.DeploymentReport;
import org.alfresco.service.cmr.avm.deploy.DeploymentReportCallback;
import org.alfresco.service.cmr.avm.deploy.DeploymentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Deleter;
import org.alfresco.util.NameMatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class DeploymentServiceImplFSTest
extends AVMServiceTestBase {
    private File log = null;
    private File metadata = null;
    private File data = null;
    private File target = null;
    private String TEST_USER = "Giles";
    private String TEST_PASSWORD = "Watcher";
    private String TEST_TARGET = "sampleTarget";
    DeploymentService service = null;
    private static Log logger = LogFactory.getLog(DeploymentServiceImplFSTest.class);

    protected void setUp() throws Exception {
        super.setUp();
        this.log = new File("deplog");
        this.log.mkdir();
        this.metadata = new File("depmetadata");
        this.metadata.mkdir();
        this.data = new File("depdata");
        this.data.mkdir();
        this.target = new File("sampleTarget");
        this.target.mkdir();
        FileSystemXmlApplicationContext receiverContext = new FileSystemXmlApplicationContext("../deployment/config/application-context.xml");
        this.service = (DeploymentService)fContext.getBean("DeploymentService");
    }

    protected void tearDown() throws Exception {
        String[] listing;
        super.tearDown();
        if (this.log != null) {
            Deleter.Delete((File)this.log);
        }
        if (this.data != null) {
            Deleter.Delete((File)this.data);
        }
        if (this.metadata != null) {
            Deleter.Delete((File)this.metadata);
        }
        if (this.target != null) {
            Deleter.Delete((File)this.target);
        }
        File dot = new File(".");
        for (String name : listing = dot.list()) {
            if (!name.startsWith("dep-record-")) continue;
            File file = new File(name);
            file.delete();
        }
    }

    public void testBasic() throws Exception {
        NameMatcher matcher = (NameMatcher)fContext.getBean("globalPathExcluder");
        fService.createDirectory("main:/", "a");
        fService.createDirectory("main:/a", "b");
        fService.createDirectory("main:/a/b", "c");
        fService.createDirectory("main:/", "d");
        fService.createDirectory("main:/d", "e");
        fService.createDirectory("main:/d/e", "f");
        fService.createFile("main:/a/b/c", "foo").close();
        String fooText = "I am main:/a/b/c/foo";
        ContentWriter writer = fService.getContentWriter("main:/a/b/c/foo", true);
        writer.setEncoding("UTF-8");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/foo");
        fService.createFile("main:/a/b/c", "bar").close();
        writer = fService.getContentWriter("main:/a/b/c/bar", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent("I am main:/a/b/c/bar");
        String buffyText = "This is test data: Buffy the Vampire Slayer is an Emmy Award-winning and Golden Globe-nominated American cult television series that aired from March 10, 1997 until May 20, 2003. The series was created in 1997 by writer-director Joss Whedon under his production tag, Mutant Enemy Productions with later co-executive producers being Jane Espenson, David Fury, and Marti Noxon. The series narrative follows Buffy Summers (played by Sarah Michelle Gellar), the latest in a line of young women chosen by fate to battle against vampires, demons, and the forces of darkness as the Slayer. Like previous Slayers, Buffy is aided by a Watcher, who guides and trains her. Unlike her predecessors, Buffy surrounds herself with a circle of loyal friends who become known as the Scooby Gang.";
        fService.createFile("main:/a/b", "buffy").close();
        writer = fService.getContentWriter("main:/a/b/buffy", true);
        writer.setEncoding("UTF-16");
        writer.setMimetype("text/plain");
        writer.putContent(buffyText);
        fService.createFile("main:/a/b", "fudge.bak").close();
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        HashSet<DeploymentEvent> firstDeployment = new HashSet<DeploymentEvent>();
        firstDeployment.addAll(report.getEvents());
        DeploymentServiceImplFSTest.assertTrue((String)"first deployment no start", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.START, null, this.TEST_TARGET)));
        DeploymentServiceImplFSTest.assertTrue((String)"first deployment no finish", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.END, null, this.TEST_TARGET)));
        DeploymentServiceImplFSTest.assertTrue((String)"first deployment wrong size", (firstDeployment.size() == 11 ? 1 : 0) != 0);
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/b", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/b/c", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/c")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /d/e", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/d/e")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/b/c/foo", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/c/foo")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/b/c/bar", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/c/bar")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/b/buffy", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/buffy")));
        DeploymentServiceImplFSTest.assertFalse((String)"Fudge has not been excluded", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/fudge.bak")));
        File target = new File("sampleTarget");
        DeploymentServiceImplFSTest.assertTrue((String)"target dir does not extist", (boolean)target.exists());
        DeploymentServiceImplFSTest.assertTrue((String)"target dir is not a directory", (boolean)target.isDirectory());
        File buffyFile = new File(target.getAbsolutePath() + File.separator + "a" + File.separator + "b" + File.separator + "buffy");
        DeploymentServiceImplFSTest.assertTrue((String)"buffy file not created", (boolean)buffyFile.exists());
        DeploymentServiceImplFSTest.assertTrue((String)"buffy file is not a file", (boolean)buffyFile.isFile());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(buffyFile), "UTF-16"));
        String text = reader.readLine();
        DeploymentServiceImplFSTest.assertTrue((String)"UTF-16 buffy text is not correct", (boolean)buffyText.equals(text));
        File fooFile = new File(target.getAbsolutePath() + File.separator + "a" + File.separator + "b" + File.separator + "c" + File.separator + "foo");
        DeploymentServiceImplFSTest.assertTrue((String)"foo file not created", (boolean)fooFile.exists());
        DeploymentServiceImplFSTest.assertTrue((String)"foo file is not a file", (boolean)fooFile.isFile());
        reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fooFile), "UTF-8"));
        text = reader.readLine();
        DeploymentServiceImplFSTest.assertTrue((String)"UTF-8 foo text is not correct", (boolean)fooText.equals(text));
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        int count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        DeploymentServiceImplFSTest.assertEquals((int)2, (int)count);
        fService.removeNode("main:/a/b/c", "bar");
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        HashSet<DeploymentEvent> smallUpdate = new HashSet<DeploymentEvent>();
        smallUpdate.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        DeploymentServiceImplFSTest.assertEquals((int)3, (int)smallUpdate.size());
        DeploymentServiceImplFSTest.assertTrue((String)"Bar not deleted", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/a/b/c/bar")));
        fService.createFile("main:/d", "jonathan").close();
        fService.removeNode("main:/a/b");
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        DeploymentServiceImplFSTest.assertEquals((int)4, (int)count);
        fService.removeNode("main:/d/e");
        fService.createFile("main:/d", "e").close();
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        DeploymentServiceImplFSTest.assertEquals((int)3, (int)count);
        fService.removeNode("main:/d/e");
        fService.createDirectory("main:/d", "e");
        fService.createFile("main:/d/e", "Warren.txt").close();
        fService.createFile("main:/d/e", "It's a silly name.txt").close();
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, matcher, false, false, false, callbacks);
        count = 0;
        for (DeploymentEvent event : report) {
            System.out.println(event);
            ++count;
        }
        DeploymentServiceImplFSTest.assertEquals((int)5, (int)count);
    }

    public void testEtwoTwo507() throws Exception {
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createDirectory("main:/", "a");
        fService.createFile("main:/a", "test01.html").close();
        fService.createFile("main:/a", "test03.html").close();
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createFile("main:/a", "test02.html").close();
        fService.removeNode("main:/a", "test03.html");
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> firstDeployment = new HashSet<DeploymentEvent>();
        firstDeployment.addAll(report.getEvents());
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing: /a/test02.html", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/test02.html")));
        DeploymentServiceImplFSTest.assertTrue((String)"delete missing: /a/test03.html", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/a/test03.html")));
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
    }

    public void testCaseSensitivity() throws Exception {
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createFile("main:/", "CamelCase.txt").close();
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        HashSet<DeploymentEvent> firstDeployment = new HashSet<DeploymentEvent>();
        firstDeployment.addAll(report.getEvents());
        DeploymentServiceImplFSTest.assertTrue((String)"Create missing: /CamelCase.txt", (boolean)firstDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/CamelCase.txt")));
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        fService.removeNode("main:/", "CamelCase.txt");
        fService.createFile("main:/", "cAMELcASE.TXT").close();
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> secondDeployment = new HashSet<DeploymentEvent>();
        secondDeployment.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        DeploymentServiceImplFSTest.assertTrue((String)"delete missing: /CamelCase.txt", (boolean)secondDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/CamelCase.txt")));
        DeploymentServiceImplFSTest.assertTrue((String)"Create missing: /cAMELcASE.TXT", (boolean)secondDeployment.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/cAMELcASE.TXT")));
    }

    public void testWrongPassword() {
        logger.debug((Object)"Start testWrongPassword");
        try {
            this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, "Wrong!", this.TEST_TARGET, null, false, false, false, null);
            DeploymentServiceImplFSTest.fail((String)"Wrong password should throw exception");
        }
        catch (AVMException de) {
            de.printStackTrace();
        }
    }

    public void testWrongTarget() {
        logger.debug((Object)"Start testWrongTarget");
        try {
            this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, "crapTarget", null, false, false, false, null);
            DeploymentServiceImplFSTest.fail((String)"Wrong target should have thrown an exception");
        }
        catch (AVMException aVMException) {
            // empty catch block
        }
    }

    public void testNoExclusionFilter() throws Exception {
        logger.debug((Object)"Start testNoExclusionFilter");
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createDirectory("main:/", "a");
        fService.createDirectory("main:/a", "b");
        fService.createFile("main:/a/b", "fudge.bak").close();
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> smallUpdate = new HashSet<DeploymentEvent>();
        smallUpdate.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/fudge.bak")));
        DeploymentServiceImplFSTest.assertEquals((int)5, (int)smallUpdate.size());
    }

    public void testRevertToPreviousVersion() throws Exception {
        logger.debug((Object)"Start testRevertToPreviousVersion");
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createDirectory("main:/", "a");
        fService.createDirectory("main:/a", "b");
        fService.createFile("main:/a/b", "Zander").close();
        fService.createFile("main:/a/b", "Cordelia").close();
        fService.createFile("main:/a/b", "Buffy").close();
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        int version = (Integer)report.getEvents().get(0).getSource().getFirst();
        DeploymentServiceImplFSTest.assertTrue((String)"version is not set", (version > 0 ? 1 : 0) != 0);
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        fService.createFile("main:/a/b", "Master").close();
        fService.createFile("main:/a/b", "Drusilla").close();
        fService.removeNode("main:/a/b", "Zander");
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(version, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> smallUpdate = new HashSet<DeploymentEvent>();
        smallUpdate.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/a/b/Zander")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/a/b/Drusilla")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/a/b/Master")));
        DeploymentServiceImplFSTest.assertEquals((int)5, (int)smallUpdate.size());
    }

    public void testBulkLoad() throws Exception {
        logger.debug((Object)"Start testBulkLoad");
        DeploymentReport report = new DeploymentReport();
        ArrayList<DeploymentCallback> callbacks = new ArrayList<DeploymentCallback>();
        callbacks.add(new DeploymentReportCallback(report));
        BulkLoader loader = new BulkLoader();
        loader.setAvmService(fService);
        loader.recursiveLoad("source/java/org/alfresco/repo/avm", "main:/");
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> bigUpdate = new HashSet<DeploymentEvent>();
        bigUpdate.addAll(report.getEvents());
        DeploymentServiceImplFSTest.assertTrue((String)"big update no start", (boolean)bigUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.START, null, this.TEST_TARGET)));
        DeploymentServiceImplFSTest.assertTrue((String)"big update no finish", (boolean)bigUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.END, null, this.TEST_TARGET)));
        DeploymentServiceImplFSTest.assertTrue((String)"big update too small", (bigUpdate.size() > 100 ? 1 : 0) != 0);
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing /avm/AVMServiceTest.java", (boolean)bigUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.CREATED, null, "/avm/AVMServiceTest.java")));
        fService.removeNode("main:/avm/ibatis");
        fService.getFileOutputStream("main:/avm/AVMServiceTest.java").close();
        report = new DeploymentReport();
        callbacks = new ArrayList();
        callbacks.add(new DeploymentReportCallback(report));
        this.service.deployDifferenceFS(-1, "main:/", "default", "localhost", 44100, this.TEST_USER, this.TEST_PASSWORD, this.TEST_TARGET, null, false, false, false, callbacks);
        HashSet<DeploymentEvent> smallUpdate = new HashSet<DeploymentEvent>();
        smallUpdate.addAll(report.getEvents());
        for (DeploymentEvent event : report) {
            System.out.println(event);
        }
        DeploymentServiceImplFSTest.assertEquals((int)4, (int)smallUpdate.size());
        DeploymentServiceImplFSTest.assertTrue((String)"Start missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.START, null, this.TEST_TARGET)));
        DeploymentServiceImplFSTest.assertTrue((String)"End missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.DELETED, null, "/avm/ibatis")));
        DeploymentServiceImplFSTest.assertTrue((String)"Update missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.UPDATED, null, "/avm/AVMServiceTest.java")));
        DeploymentServiceImplFSTest.assertTrue((String)"Delete Missing", (boolean)smallUpdate.contains(new DeploymentEvent(DeploymentEvent.Type.END, null, this.TEST_TARGET)));
    }
}

