/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.descriptor;

import java.lang.reflect.Constructor;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.descriptor.DescriptorServiceAvailableEvent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.alfresco.service.license.LicenseException;
import org.alfresco.service.license.LicenseService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.VersionNumber;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class DescriptorServiceImpl
extends AbstractLifecycleBean
implements DescriptorService,
InitializingBean {
    private DescriptorDAO serverDescriptorDAO;
    private DescriptorDAO currentRepoDescriptorDAO;
    private DescriptorDAO installedRepoDescriptorDAO;
    private TransactionService transactionService;
    private LicenseService licenseService;
    private Object heartBeat;
    private Descriptor serverDescriptor;
    private Descriptor currentRepoDescriptor;
    private Descriptor installedRepoDescriptor;

    public void setServerDescriptorDAO(DescriptorDAO serverDescriptorDAO) {
        this.serverDescriptorDAO = serverDescriptorDAO;
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setInstalledRepoDescriptorDAO(DescriptorDAO installedRepoDescriptorDAO) {
        this.installedRepoDescriptorDAO = installedRepoDescriptorDAO;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public Descriptor getServerDescriptor() {
        return this.serverDescriptor;
    }

    public Descriptor getCurrentRepositoryDescriptor() {
        return this.currentRepoDescriptor;
    }

    public Descriptor getInstalledRepositoryDescriptor() {
        return this.installedRepoDescriptor;
    }

    public LicenseDescriptor getLicenseDescriptor() {
        return this.licenseService == null ? null : this.licenseService.getLicense();
    }

    protected void onBootstrap(ApplicationEvent event) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                boolean initialiseHeartBeat;
                DescriptorServiceImpl.this.licenseService = DescriptorServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<LicenseService>(){

                    @Override
                    public LicenseService execute() {
                        return (LicenseService)DescriptorServiceImpl.this.constructSpecialService("org.alfresco.enterprise.license.LicenseComponent");
                    }
                }, DescriptorServiceImpl.this.transactionService.isReadOnly(), false);
                if (DescriptorServiceImpl.this.licenseService == null) {
                    DescriptorServiceImpl.this.licenseService = new NOOPLicenseService();
                    initialiseHeartBeat = true;
                } else {
                    initialiseHeartBeat = false;
                }
                ApplicationContext applicationContext = DescriptorServiceImpl.this.getApplicationContext();
                if (applicationContext instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)applicationContext).getBeanFactory().registerSingleton("licenseService", (Object)DescriptorServiceImpl.this.licenseService);
                }
                DescriptorServiceImpl.this.installedRepoDescriptor = DescriptorServiceImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Descriptor>(){

                    @Override
                    public Descriptor execute() throws ClassNotFoundException {
                        try {
                            DescriptorServiceImpl.this.licenseService.verifyLicense();
                            LicenseDescriptor l = DescriptorServiceImpl.this.licenseService.getLicense();
                            if (initialiseHeartBeat || l == null || !l.isHeartBeatDisabled()) {
                                DescriptorServiceImpl.this.heartBeat = DescriptorServiceImpl.this.constructSpecialService("org.alfresco.enterprise.heartbeat.HeartBeat");
                            }
                        }
                        catch (LicenseException e) {
                            DescriptorServiceImpl.this.heartBeat = DescriptorServiceImpl.this.constructSpecialService("org.alfresco.enterprise.heartbeat.HeartBeat");
                            throw e;
                        }
                        DescriptorServiceImpl.this.currentRepoDescriptor = DescriptorServiceImpl.this.currentRepoDescriptorDAO.updateDescriptor(DescriptorServiceImpl.this.serverDescriptor);
                        Descriptor installed = DescriptorServiceImpl.this.installedRepoDescriptorDAO.getDescriptor();
                        return installed == null ? new UnknownDescriptor() : installed;
                    }
                }, DescriptorServiceImpl.this.transactionService.isReadOnly(), false);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        ((ApplicationContext)event.getSource()).publishEvent((ApplicationEvent)new DescriptorServiceAvailableEvent(this));
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.licenseService != null) {
            this.licenseService.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.serverDescriptor = this.serverDescriptorDAO.getDescriptor();
    }

    private Object constructSpecialService(String className) {
        try {
            Class<?> componentClass = Class.forName(className);
            Constructor<?> constructor = componentClass.getConstructor(ApplicationContext.class);
            return constructor.newInstance(this.getApplicationContext());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to initialise " + className, (Throwable)e);
        }
    }

    public static abstract class BaseDescriptor
    implements Descriptor {
        private VersionNumber versionNumber = null;
        private String strVersion = null;

        public VersionNumber getVersionNumber() {
            if (this.versionNumber == null) {
                StringBuilder version = new StringBuilder();
                version.append(this.getVersionMajor());
                version.append(".");
                version.append(this.getVersionMinor());
                version.append(".");
                version.append(this.getVersionRevision());
                this.versionNumber = new VersionNumber(version.toString());
            }
            return this.versionNumber;
        }

        public String getVersion() {
            if (this.strVersion == null) {
                boolean hasBuild;
                StringBuilder version = new StringBuilder(this.getVersionMajor());
                version.append(".");
                version.append(this.getVersionMinor());
                version.append(".");
                version.append(this.getVersionRevision());
                String label = this.getVersionLabel();
                String build = this.getVersionBuild();
                boolean hasLabel = label != null && label.length() > 0;
                boolean bl = hasBuild = build != null && build.length() > 0;
                if (hasLabel || hasBuild) {
                    version.append(" (");
                }
                if (hasLabel) {
                    version.append(label);
                }
                if (hasBuild) {
                    if (hasLabel) {
                        version.append(" ");
                    }
                    version.append(build);
                }
                if (hasLabel || hasBuild) {
                    version.append(")");
                }
                this.strVersion = version.toString();
            }
            return this.strVersion;
        }

        protected int getSchema(String schemaStr) {
            if (schemaStr == null) {
                return 0;
            }
            try {
                int schema = Integer.parseInt(schemaStr);
                if (schema < 0) {
                    throw new NumberFormatException();
                }
                return schema;
            }
            catch (NumberFormatException e) {
                throw new AlfrescoRuntimeException("Schema must be a positive integer '" + schemaStr + "' is not!");
            }
        }
    }

    private class UnknownDescriptor
    implements Descriptor {
        private UnknownDescriptor() {
        }

        public String getId() {
            return "Unknown";
        }

        public String getName() {
            return "Unknown";
        }

        public String getVersionMajor() {
            return "Unknown";
        }

        public String getVersionMinor() {
            return "Unknown";
        }

        public String getVersionRevision() {
            return "Unknown";
        }

        public String getVersionLabel() {
            return "Unknown";
        }

        public String getVersionBuild() {
            return "Unknown";
        }

        public VersionNumber getVersionNumber() {
            return new VersionNumber("1.0.0");
        }

        public String getVersion() {
            return "Unknown (pre 1.0.0 RC2)";
        }

        public String getEdition() {
            return "Unknown";
        }

        public int getSchema() {
            return 0;
        }

        public String[] getDescriptorKeys() {
            return new String[0];
        }

        public String getDescriptor(String key) {
            return null;
        }
    }

    private class NOOPLicenseService
    implements LicenseService {
        private NOOPLicenseService() {
        }

        public void verifyLicense() throws LicenseException {
        }

        public boolean isLicenseValid() {
            return true;
        }

        public LicenseDescriptor getLicense() throws LicenseException {
            return null;
        }

        public void shutdown() {
        }
    }
}

