/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary.constraint;

import org.alfresco.repo.dictionary.constraint.AbstractConstraint;
import org.alfresco.service.cmr.dictionary.ConstraintException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.security.AuthorityType;

public class AuthorityNameConstraint
extends AbstractConstraint {
    private static final String ERR_INVALID_AUTHORITY_NAME = "d_dictionary.constraint.authority_name.invalid_authority_name";
    private static final String ERR_NON_STRING = "d_dictionary.constraint.authority_name.non_string";

    protected void evaluateSingleValue(Object value) {
        String checkValue = null;
        try {
            checkValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, value);
        }
        catch (TypeConversionException e) {
            throw new ConstraintException(ERR_NON_STRING, new Object[]{value});
        }
        AuthorityType type = AuthorityType.getAuthorityType((String)checkValue);
        if (type != AuthorityType.GROUP && type != AuthorityType.ROLE) {
            throw new ConstraintException(ERR_INVALID_AUTHORITY_NAME, new Object[]{value, type});
        }
    }
}

