/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.audit;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.audit.AuditApplicationEntity;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.domain.audit.AuditEntryEntity;
import org.alfresco.repo.domain.audit.AuditModelEntity;
import org.alfresco.repo.domain.audit.AuditQueryResult;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.propval.PropertyIdSearchRow;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuditDAOImpl
implements AuditDAO {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ContentService contentService;
    private ContentDataDAO contentDataDAO;
    protected PropertyValueDAO propertyValueDAO;

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setPropertyValueDAO(PropertyValueDAO propertyValueDAO) {
        this.propertyValueDAO = propertyValueDAO;
    }

    protected PropertyValueDAO getPropertyValueDAO() {
        return this.propertyValueDAO;
    }

    /*
     * Loose catch block
     */
    @Override
    public Pair<Long, ContentData> getOrCreateAuditModel(URL url) {
        Pair pair;
        InputStream is;
        block14: {
            long crc;
            block12: {
                Pair pair2;
                block13: {
                    is = null;
                    is = url.openStream();
                    CRC32 crcCalc = new CRC32();
                    byte[] buffer = new byte[1024];
                    int read = -1;
                    while ((read = is.read(buffer)) >= 0) {
                        crcCalc.update(buffer, 0, read);
                    }
                    crc = crcCalc.getValue();
                    AuditModelEntity existingEntity = this.getAuditModelByCrc(crc);
                    if (existingEntity == null) break block12;
                    Long existingEntityId = existingEntity.getId();
                    ContentData existingContentData = (ContentData)this.contentDataDAO.getContentData(existingEntity.getContentDataId()).getSecond();
                    Pair result = new Pair((Object)existingEntityId, (Object)existingContentData);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found existing model with same CRC: \n   URL:    " + url + "\n" + "   CRC:    " + crc + "\n" + "   Result: " + result));
                    }
                    pair2 = result;
                    Object var16_17 = null;
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                }
                return pair2;
            }
            is.close();
            is = url.openStream();
            ContentWriter writer = this.contentService.getWriter(null, null, false);
            writer.setEncoding("UTF-8");
            writer.setMimetype("text/xml");
            writer.putContent(is);
            ContentData newContentData = writer.getContentData();
            Long newContentDataId = (Long)this.contentDataDAO.createContentData(newContentData).getFirst();
            AuditModelEntity newEntity = this.createAuditModel(newContentDataId, crc);
            Pair result = new Pair((Object)newEntity.getId(), (Object)newContentData);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created new audit model: \n   URL:    " + url + "\n" + "   CRC:    " + crc + "\n" + "   Result: " + result));
            }
            pair = result;
            Object var16_18 = null;
            if (is == null) break block14;
            try {
                is.close();
            }
            catch (Throwable e2) {
                // empty catch block
            }
        }
        return pair;
        catch (IOException e) {
            try {
                throw new AlfrescoRuntimeException("Failed to read Audit model: " + url);
            }
            catch (Throwable throwable) {
                block15: {
                    Object var16_19 = null;
                    if (is == null) break block15;
                    try {
                        is.close();
                    }
                    catch (Throwable e2) {}
                }
                throw throwable;
            }
        }
    }

    protected abstract AuditModelEntity getAuditModelByCrc(long var1);

    protected abstract AuditModelEntity createAuditModel(Long var1, long var2);

    @Override
    public AuditDAO.AuditApplicationInfo getAuditApplication(String application) {
        AuditApplicationEntity entity = this.getAuditApplicationByName(application);
        if (entity == null) {
            return null;
        }
        AuditDAO.AuditApplicationInfo appInfo = new AuditDAO.AuditApplicationInfo();
        appInfo.setId(entity.getId());
        appInfo.setname(application);
        appInfo.setModelId(entity.getAuditModelId());
        appInfo.setDisabledPathsId(entity.getDisabledPathsId());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found existing audit application: \n  " + appInfo));
        }
        return appInfo;
    }

    @Override
    public AuditDAO.AuditApplicationInfo createAuditApplication(String application, Long modelId) {
        Long appNameId = (Long)this.propertyValueDAO.getOrCreatePropertyValue((Serializable)((Object)application)).getFirst();
        HashSet disabledPaths = new HashSet();
        Long disabledPathsId = this.propertyValueDAO.createProperty(disabledPaths);
        AuditApplicationEntity entity = this.createAuditApplication(appNameId, modelId, disabledPathsId);
        AuditDAO.AuditApplicationInfo appInfo = new AuditDAO.AuditApplicationInfo();
        appInfo.setId(entity.getId());
        appInfo.setname(application);
        appInfo.setModelId(modelId);
        appInfo.setDisabledPathsId(disabledPathsId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new audit application: \n   Model:  " + modelId + "\n" + "   App:    " + application + "\n" + "   Result: " + entity));
        }
        return appInfo;
    }

    @Override
    public void updateAuditApplicationModel(Long id, Long modelId) {
        AuditApplicationEntity entity = this.getAuditApplicationById(id);
        if (entity == null) {
            throw new DataIntegrityViolationException("No audit application exists for ID " + id);
        }
        if (entity.getAuditModelId().equals(modelId)) {
            return;
        }
        entity.setAuditModelId(modelId);
        this.updateAuditApplication(entity);
    }

    @Override
    public void updateAuditApplicationDisabledPaths(Long id, Set<String> disabledPaths) {
        AuditApplicationEntity entity = this.getAuditApplicationById(id);
        if (entity == null) {
            throw new DataIntegrityViolationException("No audit application exists for ID " + id);
        }
        Long disabledPathsId = entity.getDisabledPathsId();
        Set oldDisabledPaths = (Set)((Object)this.propertyValueDAO.getPropertyById(disabledPathsId));
        if (((Object)oldDisabledPaths).equals(disabledPaths)) {
            return;
        }
        this.propertyValueDAO.updateProperty(disabledPathsId, (Serializable)((Object)disabledPaths));
        this.updateAuditApplication(entity);
    }

    protected abstract AuditApplicationEntity getAuditApplicationById(Long var1);

    protected abstract AuditApplicationEntity getAuditApplicationByName(String var1);

    protected abstract AuditApplicationEntity createAuditApplication(Long var1, Long var2, Long var3);

    protected abstract AuditApplicationEntity updateAuditApplication(AuditApplicationEntity var1);

    @Override
    public Long createAuditEntry(Long applicationId, long time, String username, Map<String, Serializable> values) {
        Long usernameId = username != null ? (Long)this.propertyValueDAO.getOrCreatePropertyValue((Serializable)((Object)username)).getFirst() : null;
        Long valuesId = null;
        if (values != null && values.size() > 0) {
            valuesId = this.propertyValueDAO.createProperty((Serializable)((Object)values));
        }
        AuditEntryEntity entity = this.createAuditEntry(applicationId, time, usernameId, valuesId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created new audit entry: \n   Application: " + applicationId + "\n" + "   Time:        " + new Date(time) + "\n" + "   User:        " + username + "\n" + "   Result:      " + entity));
        }
        return entity.getId();
    }

    @Override
    public int deleteAuditEntries(List<Long> auditEntryIds) {
        TreeSet<Long> ids = new TreeSet<Long>(auditEntryIds);
        int shouldDelete = ids.size();
        int deleted = 0;
        ArrayList<Long> batch = new ArrayList<Long>(shouldDelete > 512 ? 512 : shouldDelete);
        for (Long id : ids) {
            batch.add(id);
            if (batch.size() < 512) continue;
            deleted += this.deleteAuditEntriesImpl(batch);
            batch.clear();
        }
        if (batch.size() > 0) {
            deleted += this.deleteAuditEntriesImpl(batch);
        }
        if (deleted != shouldDelete) {
            throw new ConcurrencyFailureException("Deleted " + deleted + " audit entries out of a set of " + shouldDelete + " unique IDs.");
        }
        return deleted;
    }

    protected abstract AuditEntryEntity createAuditEntry(Long var1, long var2, Long var4, Long var5);

    protected abstract int deleteAuditEntriesImpl(List<Long> var1);

    @Override
    public void findAuditEntries(AuditService.AuditQueryCallback callback, AuditQueryParameters parameters, int maxResults) {
        String searchKey = null;
        Serializable searchValue = null;
        if (parameters.getSearchKeyValues().size() > 0) {
            Pair<String, Serializable> searchKeyValue = parameters.getSearchKeyValues().get(0);
            searchKey = (String)searchKeyValue.getFirst();
            searchValue = (Serializable)searchKeyValue.getSecond();
        }
        AuditQueryRowHandler rowHandler = new AuditQueryRowHandler(callback);
        this.findAuditEntries(rowHandler, parameters.isForward(), parameters.getApplicationName(), parameters.getUser(), parameters.getFromId(), parameters.getToId(), parameters.getFromTime(), parameters.getToTime(), maxResults, searchKey, searchValue);
    }

    protected abstract void findAuditEntries(AuditQueryRowHandler var1, boolean var2, String var3, String var4, Long var5, Long var6, Long var7, Long var8, int var9, String var10, Serializable var11);

    protected class AuditQueryRowHandler {
        private final AuditService.AuditQueryCallback callback;
        private boolean more;

        private AuditQueryRowHandler(AuditService.AuditQueryCallback callback) {
            this.callback = callback;
            this.more = true;
        }

        public boolean valuesRequired() {
            return this.callback.valuesRequired();
        }

        public void processResult(AuditQueryResult row) {
            if (!this.more) {
                return;
            }
            Map auditValues = null;
            if (this.valuesRequired() && (auditValues = row.getAuditValue()) == null) {
                List<PropertyIdSearchRow> propMapRows = row.getAuditValueRows();
                if (propMapRows == null) {
                    Long auditValuesId = row.getAuditValuesId();
                    Pair<Long, Serializable> auditValuesPair = AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(auditValuesId);
                    if (auditValuesPair == null) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry not joined to audit properties: " + row, null);
                        return;
                    }
                    auditValues = (Map)auditValuesPair.getSecond();
                } else {
                    try {
                        auditValues = (Map)((Object)AbstractAuditDAOImpl.this.propertyValueDAO.convertPropertyIdSearchRows(propMapRows));
                    }
                    catch (ClassCastException e) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry not linked to a Map<String, Serializable> value: " + row, e);
                        return;
                    }
                    catch (Throwable e) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry unable to extract audited values: " + row, e);
                        return;
                    }
                    if (auditValues == null) {
                        this.more = this.callback.handleAuditEntryError(row.getAuditEntryId(), "Audit entry incompletely joined to audit properties: " + row, null);
                        return;
                    }
                }
            }
            String auditAppName = (String)AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(row.getAuditAppNameId()).getSecond();
            Long auditUserId = row.getAuditUserId();
            String auditUser = auditUserId == null ? null : (String)AbstractAuditDAOImpl.this.propertyValueDAO.getPropertyValueById(auditUserId).getSecond();
            this.more = this.callback.handleAuditEntry(row.getAuditEntryId(), auditAppName, auditUser, row.getAuditTime(), auditValues);
        }
    }
}

