/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.audit;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.domain.audit.AuditDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.apache.commons.lang.mutable.MutableInt;
import org.springframework.context.ConfigurableApplicationContext;

public class AuditDAOTest
extends TestCase {
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private AuditDAO auditDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.auditDAO = (AuditDAO)this.ctx.getBean("auditDAO");
    }

    public void testAuditModel() throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, ContentData>>(){

            @Override
            public Pair<Long, ContentData> execute() throws Throwable {
                Pair<Long, ContentData> auditModelPair = AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url);
                return auditModelPair;
            }
        };
        Pair<Long, ContentData> configPair = this.txnHelper.doInTransaction(callback);
        AuditDAOTest.assertNotNull(configPair);
        Pair<Long, ContentData> configPairCheck = this.txnHelper.doInTransaction(callback);
        AuditDAOTest.assertNotNull(configPairCheck);
        AuditDAOTest.assertEquals(configPair, configPairCheck);
    }

    public void testAuditApplication() throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createModelCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                return (Long)AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url).getFirst();
            }
        };
        final Long modelId = this.txnHelper.doInTransaction(createModelCallback);
        final String appName = this.getName() + "." + System.currentTimeMillis();
        int count = 1000;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createAppCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (int i = 0; i < 1000; ++i) {
                    AuditDAO.AuditApplicationInfo appInfo = AuditDAOTest.this.auditDAO.getAuditApplication(appName);
                    if (appInfo != null) continue;
                    AuditDAO.AuditApplicationInfo auditApplicationInfo = AuditDAOTest.this.auditDAO.createAuditApplication(appName, modelId);
                }
                return null;
            }
        };
        long before = System.nanoTime();
        this.txnHelper.doInTransaction(createAppCallback);
        long after = System.nanoTime();
        System.out.println("Time for 1000 application creations was " + (double)(after - before) / 1.0E7 + "ms");
    }

    public void testAuditEntry() throws Exception {
        this.doAuditEntryImpl(1000);
    }

    private String doAuditEntryImpl(final int count) throws Exception {
        File file = AbstractContentTransformerTest.loadQuickTestFile("pdf");
        AuditDAOTest.assertNotNull((Object)file);
        final URL url = new URL("file:" + file.getAbsolutePath());
        final String appName = this.getName() + "." + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Long> createAppCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                AuditDAO.AuditApplicationInfo appInfo = AuditDAOTest.this.auditDAO.getAuditApplication(appName);
                if (appInfo == null) {
                    Long modelId = (Long)AuditDAOTest.this.auditDAO.getOrCreateAuditModel(url).getFirst();
                    appInfo = AuditDAOTest.this.auditDAO.createAuditApplication(appName, modelId);
                }
                return appInfo.getId();
            }
        };
        final Long sessionId = this.txnHelper.doInTransaction(createAppCallback);
        String username = "alexi";
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createEntryCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (int i = 0; i < count; ++i) {
                    Map<String, Serializable> values = Collections.singletonMap("/a/b/c", new Integer(i));
                    long now = System.currentTimeMillis();
                    AuditDAOTest.this.auditDAO.createAuditEntry(sessionId, now, "alexi", values);
                }
                return null;
            }
        };
        long before = System.nanoTime();
        this.txnHelper.doInTransaction(createEntryCallback);
        long after = System.nanoTime();
        System.out.println("Time for " + count + " entry creations was " + (double)(after - before) / 1.0E7 + "ms");
        return appName;
    }

    public synchronized void testAuditQuery() throws Exception {
        this.doAuditEntryImpl(1);
        final MutableInt count = new MutableInt(0);
        final LinkedList timestamps = new LinkedList();
        final AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return false;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                count.setValue(count.intValue() + 1);
                timestamps.add(time);
                return true;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        final AuditQueryParameters params = new AuditQueryParameters();
        params.addSearchKey("/a/b/c", null);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> findCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                return null;
            }
        };
        count.setValue(0);
        timestamps.clear();
        this.txnHelper.doInTransaction(findCallback);
        AuditDAOTest.assertTrue((String)"Expected at least one result", (count.intValue() > 0 ? 1 : 0) != 0);
        ((Object)((Object)this)).wait(1000L);
        this.doAuditEntryImpl(1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> findReverseCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                params.setForward(false);
                AuditDAOTest.this.auditDAO.findAuditEntries(callback, params, 2);
                params.setForward(true);
                return null;
            }
        };
        timestamps.clear();
        this.txnHelper.doInTransaction(findReverseCallback);
    }

    public void testAuditDeleteEntries() throws Exception {
        final AuditService.AuditQueryCallback noResultsCallback = new AuditService.AuditQueryCallback(){

            @Override
            public boolean valuesRequired() {
                return false;
            }

            @Override
            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                Assert.fail((String)"Expected no results.  All entries should have been removed.");
                return false;
            }

            @Override
            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                throw new AlfrescoRuntimeException(errorMsg, error);
            }
        };
        final String appName = this.doAuditEntryImpl(1);
        final AuditQueryParameters params = new AuditQueryParameters();
        params.setApplicationName(appName);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deletedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Long appId = AuditDAOTest.this.auditDAO.getAuditApplication(appName).getId();
                AuditDAOTest.this.auditDAO.deleteAuditEntries(appId, null, null);
                AuditDAOTest.this.auditDAO.findAuditEntries(noResultsCallback, params, -1);
                return null;
            }
        };
        this.txnHelper.doInTransaction(deletedCallback);
    }
}

