/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.usage;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.domain.usage.UsageDeltaEntity;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUsageDAOImpl
implements UsageDAO {
    private NodeDAO nodeDAO;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    private long getNodeIdNotNull(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeRef);
        if (nodePair == null) {
            throw new InvalidNodeRefException("Node does not exist: " + nodeRef, nodeRef);
        }
        return (Long)nodePair.getFirst();
    }

    private NodeRef getNodeRefNotNull(long nodeId) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeId);
        if (nodePair == null) {
            throw new AlfrescoRuntimeException("Node does not exist: " + nodeId);
        }
        return (NodeRef)nodePair.getSecond();
    }

    @Override
    public int deleteDeltas(NodeRef nodeRef) {
        long nodeId = this.getNodeIdNotNull(nodeRef);
        return this.deleteDeltas(nodeId);
    }

    @Override
    public int deleteDeltas(long nodeId) {
        return this.deleteUsageDeltaEntitiesByNodeId(nodeId);
    }

    @Override
    public long getTotalDeltaSize(NodeRef nodeRef, boolean removeDeltas) {
        long nodeId = this.getNodeIdNotNull(nodeRef);
        UsageDeltaEntity entity = this.selectTotalUsageDeltaSize(nodeId);
        Long totalSize = entity.getDeltaSize();
        if (removeDeltas) {
            int deleted = this.deleteUsageDeltaEntitiesByNodeId(nodeId);
            if (entity.getDeltaCount() != null && entity.getDeltaCount() != deleted) {
                throw new ConcurrencyFailureException("The number of usage deltas was " + entity.getDeltaCount() + " but only " + deleted + " were deleted.");
            }
        }
        return totalSize != null ? totalSize : 0L;
    }

    @Override
    public void insertDelta(NodeRef usageNodeRef, long deltaSize) {
        long nodeId = this.getNodeIdNotNull(usageNodeRef);
        UsageDeltaEntity entity = new UsageDeltaEntity(nodeId, deltaSize);
        this.insertUsageDeltaEntity(entity);
    }

    @Override
    public Set<NodeRef> getUsageDeltaNodes() {
        List<Long> nodeIds = this.selectUsageDeltaNodes();
        HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>(nodeIds.size());
        for (Long nodeId : nodeIds) {
            nodeRefs.add(this.getNodeRefNotNull(nodeId));
        }
        return nodeRefs;
    }

    @Override
    public void getUserContentSizesForStore(StoreRef storeRef, UsageDAO.MapHandler resultsCallback) {
        this.selectUserContentSizesForStore(storeRef, resultsCallback);
    }

    @Override
    public void getUsersWithoutUsage(StoreRef storeRef, UsageDAO.MapHandler handler) {
        this.selectUsersWithoutUsage(storeRef, handler);
    }

    @Override
    public void getUsersWithUsage(StoreRef storeRef, UsageDAO.MapHandler handler) {
        this.selectUsersWithUsage(storeRef, handler);
    }

    protected abstract UsageDeltaEntity insertUsageDeltaEntity(UsageDeltaEntity var1);

    protected abstract UsageDeltaEntity selectTotalUsageDeltaSize(long var1);

    protected abstract List<Long> selectUsageDeltaNodes();

    protected abstract void selectUsersWithoutUsage(StoreRef var1, UsageDAO.MapHandler var2);

    protected abstract void selectUsersWithUsage(StoreRef var1, UsageDAO.MapHandler var2);

    protected abstract void selectUserContentSizesForStore(StoreRef var1, UsageDAO.MapHandler var2);

    protected abstract int deleteUsageDeltaEntitiesByNodeId(long var1);
}

