/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.FormService;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.FormProcessor;
import org.alfresco.repo.forms.processor.FormProcessorRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormServiceImpl
implements FormService {
    private static Log logger = LogFactory.getLog(FormServiceImpl.class);
    private FormProcessorRegistry processorRegistry;

    public void setProcessorRegistry(FormProcessorRegistry registry) {
        this.processorRegistry = registry;
    }

    @Override
    public Form getForm(Item item) {
        return this.getForm(item, null, null, null);
    }

    @Override
    public Form getForm(Item item, Map<String, Object> context) {
        return this.getForm(item, null, null, context);
    }

    @Override
    public Form getForm(Item item, List<String> fields) {
        return this.getForm(item, fields, null, null);
    }

    @Override
    public Form getForm(Item item, List<String> fields, Map<String, Object> context) {
        return this.getForm(item, fields, null, context);
    }

    @Override
    public Form getForm(Item item, List<String> fields, List<String> forcedFields) {
        return this.getForm(item, fields, forcedFields, null);
    }

    @Override
    public Form getForm(Item item, List<String> fields, List<String> forcedFields, Map<String, Object> context) {
        FormProcessor processor;
        if (this.processorRegistry == null) {
            throw new FormException("Property 'processorRegistry' has not been set.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving form for item: " + item));
        }
        if ((processor = this.processorRegistry.getApplicableFormProcessor(item)) == null) {
            throw new FormException("Failed to find appropriate FormProcessor to generate Form for item: " + item);
        }
        return processor.generate(item, fields, forcedFields, context);
    }

    @Override
    public Object saveForm(Item item, FormData data) {
        FormProcessor processor;
        if (this.processorRegistry == null) {
            throw new FormException("FormProcessorRegistry has not been setup");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Saving form for item '" + item + "': " + data));
        }
        if ((processor = this.processorRegistry.getApplicableFormProcessor(item)) == null) {
            throw new FormException("Failed to find appropriate FormProcessor to persist Form for item: " + item);
        }
        return processor.persist(item, data);
    }
}

