/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.forms.DataTypeParameters;
import org.alfresco.repo.forms.FieldDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFieldDefinition
extends FieldDefinition {
    private static Log logger = LogFactory.getLog(PropertyFieldDefinition.class);
    protected String dataType;
    protected DataTypeParameters dataTypeParams;
    protected boolean mandatory = false;
    protected boolean repeats = false;
    protected List<FieldConstraint> constraints;

    public PropertyFieldDefinition(String name, String dataType) {
        super(name);
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public DataTypeParameters getDataTypeParameters() {
        return this.dataTypeParams;
    }

    public void setDataTypeParameters(DataTypeParameters dataTypeParams) {
        this.dataTypeParams = dataTypeParams;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isRepeating() {
        return this.repeats;
    }

    public void setRepeating(boolean repeats) {
        this.repeats = repeats;
    }

    public List<FieldConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<FieldConstraint> constraints) {
        this.constraints = constraints;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (");
        buffer.append("name=").append(this.name);
        buffer.append(", dataType=").append(this.dataType);
        buffer.append(", dataTypeParams=").append(this.dataTypeParams);
        buffer.append(", label=").append(this.label);
        buffer.append(", description=").append(this.description);
        buffer.append(", binding=").append(this.binding);
        buffer.append(", defaultValue=").append(this.defaultValue);
        buffer.append(", dataKeyName=").append(this.dataKeyName);
        buffer.append(", group=").append(this.group);
        buffer.append(", protectedField=").append(this.protectedField);
        buffer.append(", mandatory=").append(this.mandatory);
        buffer.append(", repeats=").append(this.repeats);
        buffer.append(", constraints=").append(this.constraints);
        buffer.append(")");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldConstraint {
        protected String type;
        protected Map<String, Object> params;

        public FieldConstraint(String type, Map<String, Object> params) {
            this.type = type;
            this.params = params;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getParameters() {
            return this.params;
        }

        public JSONObject getParametersAsJSON() {
            JSONObject result = null;
            if (this.params != null) {
                result = new JSONObject();
                for (String name : this.params.keySet()) {
                    try {
                        Object value = this.params.get(name);
                        if (value instanceof Collection) {
                            result.put(name, (Object)new JSONArray((Collection)value));
                            continue;
                        }
                        result.put(name, value);
                    }
                    catch (JSONException je) {
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("Failed to add constraint parameter '" + name + "' to JSON object."), (Throwable)je);
                    }
                }
            }
            return result;
        }
    }
}

