/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor;

import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.processor.FieldProcessor;
import org.alfresco.repo.forms.processor.FieldProcessorRegistry;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldProcessor<Data>
implements FieldProcessor {
    @Override
    public Field generateField(String fieldName, FormCreationData data) {
        Data typedData = this.checkDataType(data.getItemData());
        return this.generateTypedField(fieldName, data, typedData);
    }

    private Data checkDataType(Object itemData) {
        Class<Data> expectedType = this.getExpectedDataType();
        if (expectedType.isAssignableFrom(itemData.getClass())) {
            return (Data)itemData;
        }
        String msg = "Data object: " + itemData + " is not of expected type: " + expectedType;
        throw new FormException(msg, new IllegalArgumentException());
    }

    public void setFieldProcessorRegistry(FieldProcessorRegistry registry) {
        registry.register(this.getRegistryKey(), this);
    }

    protected abstract Log getLogger();

    protected abstract String getRegistryKey();

    protected abstract Class<Data> getExpectedDataType();

    protected abstract Field generateTypedField(String var1, FormCreationData var2, Data var3);
}

