/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.util.List;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassAttributeDefinition
implements PropertyDefinition,
AssociationDefinition {
    private final QName name;
    private DataTypeDefinition dataType = (DataTypeDefinition)Mockito.mock(DataTypeDefinition.class);
    private ClassDefinition targetClass = (ClassDefinition)Mockito.mock(ClassDefinition.class);
    private String description = null;
    private String defaultValue = null;
    private String title = null;
    private boolean targetMandatory = false;
    private boolean targetMany = false;
    private boolean isProtected = false;
    private boolean mandatory = false;
    private boolean multiValued = false;

    private MockClassAttributeDefinition(QName name) {
        this.name = name;
    }

    private MockClassAttributeDefinition(QName name, String title, String description, boolean isProtected) {
        this(name);
        this.title = title;
        this.description = description;
        this.isProtected = isProtected;
    }

    public static MockClassAttributeDefinition mockPropertyDefinition(QName name, QName dataTypeName) {
        MockClassAttributeDefinition mock = new MockClassAttributeDefinition(name);
        MockClassAttributeDefinition.mockDataTypeName(dataTypeName, mock);
        return mock;
    }

    public static MockClassAttributeDefinition mockPropertyDefinition(QName name, QName dataTypeName, String defaultValue) {
        MockClassAttributeDefinition mock = new MockClassAttributeDefinition(name);
        MockClassAttributeDefinition.mockDataTypeName(dataTypeName, mock);
        mock.defaultValue = defaultValue;
        return mock;
    }

    public static MockClassAttributeDefinition mockPropertyDefinition(QName name, QName dataTypeName, String title, String description, boolean isProtected, String defaultValue, boolean Mandatory, boolean multiValued) {
        MockClassAttributeDefinition mock = new MockClassAttributeDefinition(name, title, description, isProtected);
        MockClassAttributeDefinition.mockDataTypeName(dataTypeName, mock);
        mock.defaultValue = defaultValue;
        mock.mandatory = Mandatory;
        mock.multiValued = multiValued;
        return mock;
    }

    public static MockClassAttributeDefinition mockAssociationDefinition(QName name, QName targetClassName) {
        MockClassAttributeDefinition mock = new MockClassAttributeDefinition(name);
        MockClassAttributeDefinition.mockTargetClassName(targetClassName, mock);
        return mock;
    }

    public static MockClassAttributeDefinition mockAssociationDefinition(QName name, QName targetClassName, String title, String description, boolean isProtected, boolean targetMandatory, boolean targetMany) {
        MockClassAttributeDefinition mock = new MockClassAttributeDefinition(name, title, description, isProtected);
        MockClassAttributeDefinition.mockTargetClassName(targetClassName, mock);
        mock.targetMandatory = targetMandatory;
        mock.targetMany = targetMany;
        return mock;
    }

    private static void mockDataTypeName(QName dataTypeName, MockClassAttributeDefinition mock) {
        Mockito.when((Object)mock.dataType.getName()).thenReturn((Object)dataTypeName);
    }

    private static void mockTargetClassName(QName targetClassName, MockClassAttributeDefinition mock) {
        Mockito.when((Object)mock.targetClass.getName()).thenReturn((Object)targetClassName);
    }

    public List<ConstraintDefinition> getConstraints() {
        return null;
    }

    public ClassDefinition getContainerClass() {
        return null;
    }

    public DataTypeDefinition getDataType() {
        return this.dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public IndexTokenisationMode getIndexTokenisationMode() {
        return null;
    }

    public ModelDefinition getModel() {
        return null;
    }

    public QName getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isIndexedAtomically() {
        return false;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isMandatoryEnforced() {
        return false;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isOverride() {
        return false;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isStoredInIndex() {
        return false;
    }

    public ClassDefinition getSourceClass() {
        return null;
    }

    public QName getSourceRoleName() {
        return null;
    }

    public ClassDefinition getTargetClass() {
        return this.targetClass;
    }

    public QName getTargetRoleName() {
        return null;
    }

    public boolean isChild() {
        return false;
    }

    public boolean isSourceMandatory() {
        return false;
    }

    public boolean isSourceMany() {
        return false;
    }

    public boolean isTargetMandatory() {
        return this.targetMandatory;
    }

    public boolean isTargetMandatoryEnforced() {
        return false;
    }

    public boolean isTargetMany() {
        return this.targetMany;
    }
}

