/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.Managers;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapServer;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.ServerSetup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class AlfrescoImapServer
extends AbstractLifecycleBean {
    private static Log logger = LogFactory.getLog(AlfrescoImapServer.class);
    private ImapServer serverImpl;
    private int port = 143;
    private String host = "0.0.0.0";
    private ImapHostManager imapHostManager;
    private UserManager imapUserManager;
    private boolean imapServerEnabled;

    public void setImapServerEnabled(boolean imapServerEnabled) {
        this.imapServerEnabled = imapServerEnabled;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setImapHostManager(ImapHostManager imapHostManager) {
        this.imapHostManager = imapHostManager;
    }

    public void setImapUserManager(UserManager imapUserManager) {
        this.imapUserManager = imapUserManager;
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (this.imapServerEnabled) {
            Managers imapManagers = new Managers(){

                public ImapHostManager getImapHostManager() {
                    return AlfrescoImapServer.this.imapHostManager;
                }

                public UserManager getUserManager() {
                    return AlfrescoImapServer.this.imapUserManager;
                }
            };
            this.serverImpl = new ImapServer(new ServerSetup(this.port, this.host, "imap"), imapManagers);
            this.serverImpl.startService(null);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("IMAP service started on host:port " + this.host + ":" + this.port + "."));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"IMAP service is disabled.");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.serverImpl != null) {
            this.serverImpl.stopService(null);
        }
    }
}

