/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.ImapServiceImpl;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

public class ImapServiceImplTest
extends TestCase {
    private static final String USER_NAME = "admin";
    private static final String USER_PASSWORD = "admin";
    private static final String TEST_IMAP_FOLDER_NAME = "aaa";
    private static final String MAILBOX_NAME_A = "mailbox_a";
    private static final String MAILBOX_NAME_B = "mailbox_b";
    private static final String MAILBOX_PATTERN = "mailbox*";
    private static final String FOLDER_PATTERN = "___-___folder*";
    private static final String FILE_PATTERN = "___-___file*";
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private ImporterService importerService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private AlfrescoImapUser user;
    private ImapService imapService;
    private UserTransaction txn;
    private NodeRef testImapFolderNodeRef;
    private Flags flags;
    String anotherUserName;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.importerService = serviceRegistry.getImporterService();
        this.personService = serviceRegistry.getPersonService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.imapService = serviceRegistry.getImapService();
        this.searchService = serviceRegistry.getSearchService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.flags = new Flags();
        this.flags.add(Flags.Flag.SEEN);
        this.flags.add(Flags.Flag.FLAGGED);
        this.flags.add(Flags.Flag.ANSWERED);
        this.flags.add(Flags.Flag.DELETED);
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.authenticationService.authenticate("admin", "admin".toCharArray());
        IntegrityChecker.setWarnInTransaction();
        this.anotherUserName = "user" + System.currentTimeMillis();
        PropertyMap testUser = new PropertyMap();
        testUser.put(ContentModel.PROP_USERNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_FIRSTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_LASTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_EMAIL, this.anotherUserName + "@alfresco.com");
        testUser.put(ContentModel.PROP_JOBTITLE, "jobTitle");
        this.personService.createPerson(testUser);
        this.authenticationService.createAuthentication(this.anotherUserName, this.anotherUserName.toCharArray());
        this.user = new AlfrescoImapUser(this.anotherUserName + "@alfresco.com", this.anotherUserName, this.anotherUserName);
        String storePath = "workspace://SpacesStore";
        String companyHomePathInStore = "/app:company_home";
        StoreRef storeRef = new StoreRef(storePath);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef companyHomeNodeRef = (NodeRef)nodeRefs.get(0);
        ChildApplicationContextFactory imap = (ChildApplicationContextFactory)ctx.getBean("imap");
        ApplicationContext imapCtx = imap.getApplicationContext();
        ImapServiceImpl imapServiceImpl = (ImapServiceImpl)imapCtx.getBean("imapService");
        LinkedList<String> folders = new LinkedList<String>();
        folders.add(TEST_IMAP_FOLDER_NAME);
        FileFolderServiceImpl.makeFolders(this.fileFolderService, companyHomeNodeRef, folders, ContentModel.TYPE_FOLDER);
        RepositoryFolderConfigBean imapHome = new RepositoryFolderConfigBean();
        imapHome.setStore(storePath);
        imapHome.setRootPath(companyHomePathInStore);
        imapHome.setFolderPath(TEST_IMAP_FOLDER_NAME);
        imapServiceImpl.setImapHome(imapHome);
        imapServiceImpl.startup();
        nodeRefs = this.searchService.selectNodes(storeRootNodeRef, companyHomePathInStore + "/" + "cm" + ":" + TEST_IMAP_FOLDER_NAME, null, (NamespacePrefixResolver)this.namespaceService, false);
        this.testImapFolderNodeRef = (NodeRef)nodeRefs.get(0);
        this.importInternal("imap/imapservice_test_folder_a.acp", this.testImapFolderNodeRef);
        this.reauthenticate(this.anotherUserName, this.anotherUserName);
    }

    public void tearDown() throws Exception {
        try {
            this.txn.rollback();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void importInternal(String acpName, NodeRef space) throws IOException {
        ClassPathResource acpResource = new ClassPathResource(acpName);
        ACPImportPackageHandler acpHandler = new ACPImportPackageHandler(acpResource.getFile(), null);
        Location importLocation = new Location(space);
        this.importerService.importView(acpHandler, importLocation, null, null);
    }

    private boolean checkMailbox(AlfrescoImapUser user, String mailboxName) {
        AlfrescoImapFolder mailFolder = this.imapService.getFolder(user, mailboxName);
        return mailFolder.getFolderInfo() != null;
    }

    private boolean checkSubscribedMailbox(AlfrescoImapUser user, String mailboxName) {
        List<AlfrescoImapFolder> aifs = this.imapService.listSubscribedMailboxes(user, mailboxName);
        boolean present = false;
        for (AlfrescoImapFolder aif : aifs) {
            if (!aif.getName().equals(mailboxName)) continue;
            present = true;
            break;
        }
        return present;
    }

    private void reauthenticate(String name, String password) {
        this.authenticationService.invalidateTicket(this.authenticationService.getCurrentTicket());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.authenticate(name, password.toCharArray());
    }

    public void testGetFolder() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertTrue((boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testListMailbox() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.createMailbox(this.user, MAILBOX_NAME_B);
        List<AlfrescoImapFolder> mf = this.imapService.listMailboxes(this.user, MAILBOX_PATTERN);
        ImapServiceImplTest.assertEquals((int)2, (int)mf.size());
        boolean foundA = false;
        boolean foundB = false;
        for (AlfrescoImapFolder folder : mf) {
            if (MAILBOX_NAME_A.equals(folder.getName())) {
                foundA = true;
            }
            if (!MAILBOX_NAME_B.equals(folder.getName())) continue;
            foundB = true;
        }
        ImapServiceImplTest.assertTrue((String)"folder A found", (boolean)foundA);
        ImapServiceImplTest.assertTrue((String)"folder B found", (boolean)foundB);
        List<AlfrescoImapFolder> aif = this.imapService.listSubscribedMailboxes(this.user, MAILBOX_PATTERN);
        ImapServiceImplTest.assertEquals((int)2, (int)aif.size());
        this.imapService.unsubscribe(this.user, MAILBOX_NAME_B);
        List<AlfrescoImapFolder> aif2 = this.imapService.listSubscribedMailboxes(this.user, MAILBOX_PATTERN);
        ImapServiceImplTest.assertEquals((int)1, (int)aif2.size());
    }

    public void testListSubscribedMailbox() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.createMailbox(this.user, MAILBOX_NAME_B);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        this.imapService.subscribe(this.user, MAILBOX_NAME_B);
        List<AlfrescoImapFolder> aif = this.imapService.listSubscribedMailboxes(this.user, MAILBOX_PATTERN);
        ImapServiceImplTest.assertEquals((int)aif.size(), (int)2);
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox A", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox B", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testCreateMailbox() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertTrue((String)"Mailbox isn't created", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testDuplicateMailboxes() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        try {
            this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
            ImapServiceImplTest.fail((String)"Duplicate Mailbox was created");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
    }

    public void testRenameMailbox() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.renameMailbox(this.user, MAILBOX_NAME_A, MAILBOX_NAME_B);
        ImapServiceImplTest.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_A));
        ImapServiceImplTest.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testRenameMailboxDuplicate() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.createMailbox(this.user, MAILBOX_NAME_B);
        try {
            this.imapService.renameMailbox(this.user, MAILBOX_NAME_A, MAILBOX_NAME_B);
            ImapServiceImplTest.fail((String)"Mailbox was renamed to existing one but shouldn't");
        }
        catch (AlfrescoRuntimeException alfrescoRuntimeException) {
            // empty catch block
        }
    }

    public void testDeleteMailbox() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_B);
        this.imapService.deleteMailbox(this.user, MAILBOX_NAME_B);
        ImapServiceImplTest.assertFalse((String)"Can't delete mailbox", (boolean)this.checkMailbox(this.user, MAILBOX_NAME_B));
    }

    public void testSubscribe() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertTrue((String)"Can't subscribe mailbox", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
    }

    public void testUnsubscribe() throws Exception {
        this.imapService.createMailbox(this.user, MAILBOX_NAME_A);
        this.imapService.subscribe(this.user, MAILBOX_NAME_A);
        this.imapService.unsubscribe(this.user, MAILBOX_NAME_A);
        ImapServiceImplTest.assertFalse((String)"Can't unsubscribe mailbox", (boolean)this.checkSubscribedMailbox(this.user, MAILBOX_NAME_A));
    }

    private void setFlags(FileInfo messageFileInfo) throws Exception {
        this.imapService.setFlags(messageFileInfo, this.flags, true);
        NodeRef messageNodeRef = messageFileInfo.getNodeRef();
        Map props = this.nodeService.getProperties(messageNodeRef);
        ImapServiceImplTest.assertTrue((String)"Can't set SEEN flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_SEEN));
        ImapServiceImplTest.assertTrue((String)"Can't set FLAGGED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_FLAGGED));
        ImapServiceImplTest.assertTrue((String)"Can't set ANSWERED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_ANSWERED));
        ImapServiceImplTest.assertTrue((String)"Can't set DELETED flag", (boolean)props.containsKey(ImapModel.PROP_FLAG_DELETED));
    }

    public void testSetFlags() throws Exception {
        List<FileInfo> fis = this.imapService.searchMails(this.testImapFolderNodeRef, AlfrescoImapConst.ImapViewMode.ARCHIVE);
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo;
            block3: {
                messageFileInfo = fis.get(0);
                try {
                    this.setFlags(messageFileInfo);
                    ImapServiceImplTest.fail((String)"Can't set flags");
                }
                catch (Exception e) {
                    if (e instanceof AccessDeniedException) break block3;
                    throw e;
                }
            }
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            this.setFlags(messageFileInfo);
        }
    }

    public void testSetFlag() throws Exception {
        List<FileInfo> fis = this.imapService.searchMails(this.testImapFolderNodeRef, AlfrescoImapConst.ImapViewMode.ARCHIVE);
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo = fis.get(0);
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            this.imapService.setFlag(messageFileInfo, Flags.Flag.RECENT, true);
            Serializable prop = this.nodeService.getProperty(messageFileInfo.getNodeRef(), ImapModel.PROP_FLAG_RECENT);
            ImapServiceImplTest.assertNotNull((String)"Can't set RECENT flag", (Object)prop);
        }
    }

    public void testGetFlags() throws Exception {
        List<FileInfo> fis = this.imapService.searchMails(this.testImapFolderNodeRef, AlfrescoImapConst.ImapViewMode.ARCHIVE);
        if (fis != null && fis.size() > 0) {
            FileInfo messageFileInfo = fis.get(0);
            this.reauthenticate("admin", "admin");
            this.permissionService.setPermission(this.testImapFolderNodeRef, this.anotherUserName, "Write", true);
            this.imapService.setFlags(messageFileInfo, this.flags, true);
            this.reauthenticate(this.anotherUserName, this.anotherUserName);
            Flags fl = this.imapService.getFlags(messageFileInfo);
            ImapServiceImplTest.assertTrue((boolean)fl.contains(this.flags));
        }
    }
}

