/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.importer.ExportSourceImporterException;
import org.alfresco.repo.importer.ImporterJobSPI;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSourceImporter
implements ImporterJobSPI {
    private static Log s_logger = LogFactory.getLog(FileSourceImporter.class);
    private ImporterService importerService;
    private String fileLocation;
    private AuthenticationContext authenticationContext;
    private StoreRef storeRef;
    private String path;
    private boolean clearAllChildren;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private TransactionService transactionService;
    private Set<SimpleCache> caches;
    private static ImporterBinding REPLACE_BINDING = new ImporterBinding(){

        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return ImporterBinding.UUID_BINDING.UPDATE_EXISTING;
        }

        public String getValue(String key) {
            return null;
        }

        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        public QName[] getExcludedClasses() {
            return null;
        }
    };

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setFileLocation(String fileLocation) {
        this.fileLocation = fileLocation;
    }

    public void setClearAllChildren(boolean clearAllChildren) {
        this.clearAllChildren = clearAllChildren;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setStoreRef(String storeRef) {
        this.storeRef = new StoreRef(storeRef);
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCaches(Set<SimpleCache> caches) {
        this.caches = caches;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    public void doImport() {
        UserTransaction userTransaction = null;
        try {
            try {
                long start = System.nanoTime();
                userTransaction = this.transactionService.getUserTransaction();
                userTransaction.begin();
                this.authenticationContext.setSystemUserAsCurrentUser();
                if (this.clearAllChildren) {
                    List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), this.path, null, this.namespacePrefixResolver, false);
                    for (NodeRef ref : refs) {
                        for (ChildAssociationRef car : this.nodeService.getChildAssocs(ref)) {
                            this.nodeService.deleteNode(car.getChildRef());
                        }
                    }
                }
                if (this.caches != null) {
                    for (SimpleCache cache : this.caches) {
                        cache.clear();
                    }
                }
                BufferedReader reader = new BufferedReader(new FileReader(this.fileLocation));
                Location location = new Location(this.storeRef);
                location.setPath(this.path);
                this.importerService.importView(reader, location, REPLACE_BINDING, null);
                ((Reader)reader).close();
                if (this.caches != null) {
                    for (SimpleCache cache : this.caches) {
                        cache.clear();
                    }
                }
                userTransaction.commit();
                long end = System.nanoTime();
                s_logger.info((Object)("Imported " + this.fileLocation + " in " + (float)(end - start) / 1.0E9f + " seconds"));
            }
            catch (Throwable t) {
                try {
                    if (userTransaction != null) {
                        userTransaction.rollback();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.authenticationContext.clearCurrentSecurityContext();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ExportSourceImporterException("Failed to import", t);
            }
            Object var10_10 = null;
            this.authenticationContext.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.authenticationContext.clearCurrentSecurityContext();
            throw throwable;
        }
    }
}

